<?php $__env->startSection('panel'); ?>
    <div class="row mb-none-30">
        <div class="col-lg-12 col-md-12 mb-30">
            <div class="card">
                <div class="card-body">
                    <form action="" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-4 col-sm-6">
                                <div class="form-group">
                                    <label> <?php echo app('translator')->get('Site Title'); ?></label>
                                    <input class="form-control" name="site_name" type="text" value="<?php echo e($general->site_name); ?>" required>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Currency'); ?></label>
                                    <input class="form-control" name="cur_text" type="text" value="<?php echo e(__($general->cur_text)); ?>" disabled required>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Currency Symbol'); ?></label>
                                    <input class="form-control" name="cur_sym" type="text" value="<?php echo e($general->cur_sym); ?>" disabled required>
                                </div>
                            </div>
                            <div class="form-group col-md-4 col-sm-6">
                                <label> <?php echo app('translator')->get('Timezone'); ?></label>
                                <select class="select2-basic" name="timezone">
                                    <?php $__currentLoopData = $timezones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="'<?php echo e(@$timezone); ?>'"><?php echo e(__($timezone)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-md-4 col-sm-6">
                                <label> <?php echo app('translator')->get('Site Base Color'); ?></label>
                                <div class="input-group">
                                    <span class="input-group-text border-0 p-0">
                                        <input class="form-control colorPicker" type='text' value="<?php echo e($general->base_color); ?>" />
                                    </span>
                                    <input class="form-control colorCode" name="base_color" type="text" value="<?php echo e($general->base_color); ?>" />
                                </div>
                            </div>
                            <div class="form-group col-md-4 col-sm-6">
                                <label> <?php echo app('translator')->get('Site Secondary Color'); ?></label>
                                <div class="input-group">
                                    <span class="input-group-text border-0 p-0">
                                        <input class="form-control colorPicker" type='text' value="<?php echo e($general->secondary_color); ?>" />
                                    </span>
                                    <input class="form-control colorCode" name="secondary_color" type="text" value="<?php echo e($general->secondary_color); ?>" />
                                </div>
                            </div>
                            <div class="form-group col-md-3 col-sm-6">
                                <label><?php echo app('translator')->get('DH/S Price'); ?></label>
                                <div class="input-group">
                                    <span class="input-group-text"><?php echo app('translator')->get('1 DH/S'); ?> =</span>
                                    <input class="form-control form-control-lg numeric-validation" name="dhs_price" type="text" value="<?php echo e($general->dhs_price); ?>" required>
                                    <span class="input-group-text"><?php echo e(__($general->cur_text)); ?></span>
                                </div>
                            </div>
                            <div class="form-group col-md-3 col-sm-6">
                                <label><?php echo app('translator')->get('Free DH/S'); ?></label>
                                <div class="input-group">
                                    <input class="form-control form-control-lg integer-validation" name="free_dhs" type="number" value="<?php echo e($general->free_dhs); ?>" step="any" required>
                                    <span class="input-group-text"><?php echo e(__($general->cur_text)); ?></span>
                                </div>
                            </div>
                            <div class="form-group col-md-3 col-sm-6">
                                <label><?php echo app('translator')->get('Daily Earning Per DH/S'); ?></label>
                                <div class="input-group">
                                    <input class="form-control form-control-lg numeric-validation" name="daily_earning" type="text" value="<?php echo e($general->daily_earning); ?>" required>
                                    <span class="input-group-text"><?php echo e(__($general->cur_text)); ?></span>
                                </div>
                            </div>

                            <div class="form-group col-md-3 col-sm-6">
                                <label><?php echo app('translator')->get('Referral Bonus'); ?></label>
                                <div class="input-group">
                                    <input class="form-control form-control-lg numeric-validation" name="referral_bonus" type="text" value="<?php echo e($general->referral_bonus); ?>" required>
                                    <span class="input-group-text"><?php echo app('translator')->get('%'); ?></span>
                                </div>
                            </div>
                        </div>
                        <button class="btn btn--primary w-100 h-45" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/spectrum.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link href="<?php echo e(asset('assets/admin/css/spectrum.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.colorPicker').spectrum({
                color: $(this).data('color'),
                change: function(color) {
                    $(this).parent().siblings('.colorCode').val(color.toHexString().replace(/^#?/, ''));
                }
            });

            $('.colorCode').on('input', function() {
                var clr = $(this).val();
                $(this).parents('.input-group').find('.colorPicker').spectrum({
                    color: clr,
                });
            });

            $('select[name=timezone]').val("'<?php echo e(config('app.timezone')); ?>'").select2();
            $('.select2-basic').select2({
                dropdownParent: $('.card-body')
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stellar/public_html/core/resources/views/admin/setting/general.blade.php ENDPATH**/ ?>