<?php $__env->startSection('panel'); ?>


    <div class="row gy-4">
        <div class="col-xxl-3 col-sm-6">
            <div class="card bg--primary has-link box--shadow2 overflow-hidden">
                <a class="item-link" href="<?php echo e(route('admin.account.index')); ?>"></a>
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-4">
                            <i class="las la-users f-size--56"></i>
                        </div>
                        <div class="col-8 text-end">
                            <span class="text--small text-white"><?php echo app('translator')->get('Total Account'); ?></span>
                            <h2 class="text-white"><?php echo e($account['total_account']); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-3 col-sm-6">
            <div class="card bg--success has-link box--shadow2">
                <a class="item-link" href="<?php echo e(route('admin.account.active')); ?>"></a>
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-4">
                            <i class="las la-user-check f-size--56"></i>
                        </div>
                        <div class="col-8 text-end">
                            <span class="text--small text-white"><?php echo app('translator')->get('Active Account'); ?></span>
                            <h2 class="text-white"><?php echo e($account['active_account']); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <div class="card bg--danger has-link box--shadow2">
                <a class="item-link" href="<?php echo e(route('admin.account.banned')); ?>"></a>
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-4">
                            <i class="las la-ban f-size--56"></i>
                        </div>
                        <div class="col-8 text-end">
                            <span class="text--small text-white"><?php echo app('translator')->get('Banned Account'); ?></span>
                            <h2 class="text-white"><?php echo e($account['banned_account']); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <div class="card bg--10 has-link box--shadow2">
                <a class="item-link" href="<?php echo e(route('admin.account.referred')); ?>"></a>
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-4">
                            <i class="las la-user-friends f-size--56"></i>
                        </div>
                        <div class="col-8 text-end">
                            <span class="text--small text-white"><?php echo app('translator')->get('Referred Account'); ?></span>
                            <h2 class="text-white"><?php echo e($account['referred_account']); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- dashboard-w1 end -->
    </div><!-- row end-->
    <!--  widget -->
    <div class="row gy-4 mt-2">
        <div class="col-xxl-3 col-sm-6">
            <div class="widget-two box--shadow2 b-radius--5 bg--white">
                <i class="las la-wallet overlay-icon text--info"></i>
                <div class="widget-two__icon b-radius--5 bg--info">
                    <i class="las la-wallet"></i>
                </div>
                <div class="widget-two__content">
                    <h3><?php echo e(showAmount($payment['total_deposit_amount'])); ?> <?php echo e(__($general->cur_text)); ?></h3>
                    <p><?php echo app('translator')->get('Total Deposited'); ?></p>
                </div>
                <a class="widget-two__btn border--info btn-outline--info border" href="<?php echo e(route('admin.deposit.index')); ?>"><?php echo app('translator')->get('View All'); ?></a>
            </div>
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <div class="widget-two box--shadow2 b-radius--5 bg--white">
                <i class="las la-money-bill overlay-icon text--primary"></i>
                <div class="widget-two__icon b-radius--5 bg--primary">
                    <i class="las la-money-bill"></i>
                </div>
                <div class="widget-two__content">
                    <h3><?php echo e(showAmount($paymentWithdraw['total_withdraw_amount'])); ?> <?php echo e(__($general->cur_text)); ?></h3>
                    <p><?php echo app('translator')->get('Total Withdrawn'); ?></p>
                </div>
                <a class="widget-two__btn border--primary btn-outline--primary border" href="<?php echo e(route('admin.withdraw.index')); ?>"><?php echo app('translator')->get('View All'); ?></a>
            </div>
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <div class="widget-two box--shadow2 b-radius--5 bg--white">
                <i class="las la-hammer overlay-icon text--success"></i>
                <div class="widget-two__icon b-radius--5 bg--success">
                    <i class="las la-hammer"></i>
                </div>
                <div class="widget-two__content">
                    <h3><?php echo e(showAmount($account['track_balance'])); ?> <?php echo e(__($general->cur_text)); ?></h3>
                    <p><?php echo app('translator')->get('Mining Track Balance'); ?></p>
                </div>
                <a class="widget-two__btn border--success btn-outline--success border" href="<?php echo e(route('admin.mining.track')); ?>"><?php echo app('translator')->get('View All'); ?></a>
            </div>
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <div class="widget-two box--shadow2 b-radius--5 bg--white">
                <i class="las la-users overlay-icon text--dark"></i>
                <div class="widget-two__icon b-radius--5 bg--dark">
                    <i class="las la-users"></i>
                </div>
                <div class="widget-two__content">
                    <h3> <?php echo e(showAmount($account['referral_bonus'])); ?> <?php echo e(__($general->cur_text)); ?></h3>
                    <p><?php echo app('translator')->get('Referral Bonus'); ?></p>
                </div>
                <a class="widget-two__btn border--dark btn-outline--dark border" href="<?php echo e(route('admin.referral.log')); ?>"><?php echo app('translator')->get('View All'); ?></a>
            </div>
        </div><!-- dashboard-w1 end -->
    </div><!-- row end-->

    <div class="row mb-none-30 mt-30">
        <div class="col-xl-6 mb-30">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><?php echo app('translator')->get('Deposit & Withdraw  Report of Last 12 Months'); ?></h5>
                    <div id="apex-bar-chart"> </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6 mb-30">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><?php echo app('translator')->get('Last 30 days Withdraw History'); ?></h5>
                    <div id="withdraw-line"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-none-30 mt-5">
        <div class="col-xl-6 mb-30">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0"><?php echo app('translator')->get('Latest Accounts'); ?></h6>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Unique ID'); ?></th>
                                    <th><?php echo app('translator')->get('Wallet'); ?></th>
                                    <th><?php echo app('translator')->get('Referred By'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $latestAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td data-label="<?php echo app('translator')->get('Unique ID'); ?>">
                                            <a href="<?php echo e(route('admin.account.detail', $account->id)); ?>"><?php echo e($account->unique_id); ?></a>
                                        </td>
                                        <td data-label="<?php echo app('translator')->get('Wallet'); ?>"><?php echo e($account->wallet); ?></td>

                                        <td data-label="<?php echo app('translator')->get('Referred By'); ?>">
                                            <?php if($account->ref_by): ?>
                                                <a href="<?php echo e(route('admin.account.detail', $account->ref_by)); ?>">
                                                    <?php echo e($account->referral->unique_id); ?>

                                                </a>
                                            <?php else: ?>
                                                <?php echo app('translator')->get('N/A'); ?>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6 mb-30">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0"><?php echo app('translator')->get('Latest Deposits'); ?></h6>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Unique ID'); ?></th>
                                    <th><?php echo app('translator')->get('Wallet'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $latestDeposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td data-label="<?php echo app('translator')->get('Unique ID'); ?>">
                                            <a href="<?php echo e(route('admin.account.detail', $deposit->account->id)); ?>"><?php echo e(@$deposit->account->unique_id); ?></a>
                                        </td>
                                        <td data-label="<?php echo app('translator')->get('Wallet'); ?>"><?php echo e($deposit->wallet); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e(showAmount($deposit->amount)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('admin.partials.cron_instruction', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/vendor/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/vendor/chart.js.2.8.0.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        var options = {
            series: [{
                name: 'Total Deposit',
                data: [
                    <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e(getAmount(@$depositsMonth->where('months', $month)->first()->depositAmount)); ?>,
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ]
            }, {
                name: 'Total Withdraw',
                data: [
                    <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e(getAmount(@$withdrawalMonth->where('months', $month)->first()->withdrawAmount)); ?>,
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ]
            }],
            chart: {
                type: 'bar',
                height: 400,
                toolbar: {
                    show: false
                }
            },
            plotOptions: {
                bar: {
                    horizontal: false,
                    columnWidth: '50%',
                    endingShape: 'rounded'
                },
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                show: true,
                width: 2,
                colors: ['transparent']
            },
            xaxis: {
                categories: <?php echo json_encode($months, 15, 512) ?>,
            },
            yaxis: {
                title: {
                    text: "<?php echo e(__($general->cur_sym)); ?>",
                    style: {
                        color: '#7c97bb'
                    }
                }
            },
            grid: {
                xaxis: {
                    lines: {
                        show: false
                    }
                },
                yaxis: {
                    lines: {
                        show: false
                    }
                },
            },
            fill: {
                opacity: 1
            },
            tooltip: {
                y: {
                    formatter: function(val) {
                        return "<?php echo e(__($general->cur_sym)); ?>" + val + " "
                    }
                }
            }
        };

        var chart = new ApexCharts(document.querySelector("#apex-bar-chart"), options);
        chart.render();


        // apex-line chart
        var options = {
            chart: {
                height: 400,
                type: "area",
                toolbar: {
                    show: false
                },
                dropShadow: {
                    enabled: true,
                    enabledSeries: [0],
                    top: -2,
                    left: 0,
                    blur: 10,
                    opacity: 0.08
                },
                animations: {
                    enabled: true,
                    easing: 'linear',
                    dynamicAnimation: {
                        speed: 1000
                    }
                },
            },
            dataLabels: {
                enabled: false
            },
            series: [{
                name: "Series 1",
                data: <?php echo json_encode($withdrawals['per_day_amount']->flatten(), 15, 512) ?>
            }],
            fill: {
                type: "gradient",
                gradient: {
                    shadeIntensity: 1,
                    opacityFrom: 0.7,
                    opacityTo: 0.9,
                    stops: [0, 90, 100]
                }
            },
            xaxis: {
                categories: <?php echo json_encode($withdrawals['per_day']->flatten(), 15, 512) ?>
            },
            grid: {
                padding: {
                    left: 5,
                    right: 5
                },
                xaxis: {
                    lines: {
                        show: false
                    }
                },
                yaxis: {
                    lines: {
                        show: false
                    }
                },
            },
        };

        var chart = new ApexCharts(document.querySelector("#withdraw-line"), options);

        chart.render();
    </script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if($general->last_cron): ?>
        <div class="d-flex justify-content-end align-items-center flex-wrap gap-2">
            <a class="btn <?php if(Carbon\Carbon::parse($general->last_cron)->diffInSeconds() < 300): ?> btn--success <?php elseif(Carbon\Carbon::parse($general->last_cron)->diffInSeconds() < 900): ?> btn--warning <?php else: ?> btn--danger <?php endif; ?>" href="javascript:void(0)"><i class="fa fa-fw fa-clock"></i><?php echo app('translator')->get('Last Cron Run'); ?> : <?php echo e(Carbon\Carbon::parse($general->last_cron)->difFforHumans()); ?></a>
        </div>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stellar/public_html/core/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>