<style>
    .dgb-header {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        z-index: 1000;
        background: rgba(0, 0, 0, 0.95);
        backdrop-filter: blur(15px);
        border-bottom: 1px solid rgba(0, 204, 204, 0.2);
        padding: 12px 0;
        transition: all 0.3s ease;
    }

    .dgb-header-container {
        max-width: 1400px;
        margin: 0 auto;
        padding: 0 20px;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .dgb-header-logo {
        display: flex;
        align-items: center;
        gap: 12px;
        text-decoration: none;
        transition: all 0.3s ease;
    }

    .dgb-header-logo:hover {
        transform: translateX(3px);
    }

    .dgb-header-logo-icon {
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, rgba(0, 204, 204, 0.2), rgba(0, 102, 204, 0.2));
        border: 1px solid rgba(0, 204, 204, 0.3);
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        color: var(--dgb-cyan, #00cccc);
        animation: logoFloat 3s ease-in-out infinite;
    }

    @keyframes logoFloat {
        0%, 100% { transform: translateY(0px); }
        50% { transform: translateY(-3px); }
    }

    .dgb-header-logo-text {
        display: flex;
        flex-direction: column;
        gap: 2px;
    }

    .dgb-header-logo-title {
        font-family: 'Orbitron', sans-serif;
        font-size: 18px;
        font-weight: 700;
        color: var(--dgb-cyan, #00cccc);
        text-transform: uppercase;
        letter-spacing: 2px;
        line-height: 1;
    }

    .dgb-header-logo-subtitle {
        font-size: 10px;
        color: rgba(255, 255, 255, 0.5);
        text-transform: uppercase;
        letter-spacing: 1px;
        line-height: 1;
    }

    .dgb-header-actions {
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .dgb-header-user {
        display: flex;
        align-items: center;
        gap: 10px;
        padding: 8px 15px;
        background: rgba(0, 204, 204, 0.05);
        border: 1px solid rgba(0, 204, 204, 0.2);
        border-radius: 8px;
    }

    .dgb-header-user-icon {
        width: 32px;
        height: 32px;
        background: rgba(0, 204, 204, 0.15);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--dgb-cyan, #00cccc);
        font-size: 14px;
    }

    .dgb-header-user-name {
        font-size: 13px;
        color: rgba(255, 255, 255, 0.8);
        font-weight: 500;
    }

    .dgb-header-logout {
        width: 42px;
        height: 42px;
        background: rgba(220, 53, 69, 0.1);
        border: 1px solid rgba(220, 53, 69, 0.3);
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: rgba(220, 53, 69, 0.9);
        font-size: 18px;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        position: relative;
        overflow: hidden;
    }

    .dgb-header-logout::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 0;
        height: 0;
        background: rgba(220, 53, 69, 0.2);
        border-radius: 50%;
        transform: translate(-50%, -50%);
        transition: width 0.3s ease, height 0.3s ease;
    }

    .dgb-header-logout:hover::before {
        width: 100px;
        height: 100px;
    }

    .dgb-header-logout:hover {
        background: rgba(220, 53, 69, 0.2);
        border-color: rgba(220, 53, 69, 0.5);
        transform: scale(1.05);
        color: rgba(255, 70, 85, 1);
    }

    .dgb-header-logout i {
        position: relative;
        z-index: 1;
    }

    /* Logout Tooltip */
    .dgb-header-logout::after {
        content: 'Logout';
        position: absolute;
        bottom: -35px;
        left: 50%;
        transform: translateX(-50%) scale(0);
        background: rgba(0, 0, 0, 0.9);
        color: rgba(255, 255, 255, 0.9);
        padding: 6px 12px;
        border-radius: 6px;
        font-size: 11px;
        white-space: nowrap;
        pointer-events: none;
        transition: all 0.3s ease;
        border: 1px solid rgba(220, 53, 69, 0.3);
    }

    .dgb-header-logout:hover::after {
        transform: translateX(-50%) scale(1);
    }

    /* Add spacing for fixed header */
    body {
        padding-top: 68px;
    }

    /* Mobile Responsive */
    @media (max-width: 768px) {
        .dgb-header {
            padding: 12px 0;
        }

        .dgb-header-container {
            padding: 0 15px;
        }

        .dgb-header-logo-icon {
            width: 36px;
            height: 36px;
            font-size: 18px;
        }

        .dgb-header-logo-title {
            font-size: 16px;
            letter-spacing: 1px;
        }

        .dgb-header-logo-subtitle {
            font-size: 9px;
        }

        .dgb-header-user {
            padding: 6px 10px;
        }

        .dgb-header-user-icon {
            width: 28px;
            height: 28px;
            font-size: 12px;
        }

        .dgb-header-user-name {
            font-size: 12px;
        }

        .dgb-header-logout {
            width: 38px;
            height: 38px;
            font-size: 16px;
        }

        body {
            padding-top: 58px;
        }
    }

    @media (max-width: 480px) {
        .dgb-header {
            padding: 10px 0;
        }

        .dgb-header-container {
            padding: 0 10px;
            gap: 10px;
        }

        .dgb-header-logo {
            gap: 8px;
        }

        .dgb-header-logo-icon {
            width: 32px;
            height: 32px;
            font-size: 16px;
        }

        .dgb-header-logo-title {
            font-size: 14px;
        }

        .dgb-header-logo-subtitle {
            display: none;
        }

        .dgb-header-user-name {
            display: none;
        }

        .dgb-header-user {
            padding: 6px;
            min-width: auto;
        }

        .dgb-header-logout {
            width: 36px;
            height: 36px;
            font-size: 15px;
        }

        body {
            padding-top: 50px;
        }
    }
</style>

<header class="dgb-header">
    <div class="dgb-header-container">
        <!-- Logo -->
        <a href="<?php echo e(route('account.home')); ?>" class="dgb-header-logo">
            <div class="dgb-header-logo-icon">
                <i class="fas fa-cube"></i>
            </div>
            <div class="dgb-header-logo-text">
                <span class="dgb-header-logo-title">DGB Mining</span>
                <span class="dgb-header-logo-subtitle">Blockchain Secured</span>
            </div>
        </a>

        <!-- Actions -->
        <div class="dgb-header-actions">
            <!-- User Info -->
            <div class="dgb-header-user">
                <div class="dgb-header-user-icon">
                    <i class="fas fa-user"></i>
                </div>
                <span class="dgb-header-user-name"><?php echo e(Str::limit($account->wallet, 12, '...')); ?></span>
            </div>

            <!-- Logout Button -->
            <a href="<?php echo e(route('account.logout')); ?>" class="dgb-header-logout" onclick="return confirm('Are you sure you want to logout?')">
                <i class="fas fa-power-off"></i>
            </a>
        </div>
    </div>
</header>

<?php /**PATH /home/stellar/public_html/core/resources/views/templates/basic/partials/header.blade.php ENDPATH**/ ?>