@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $content = getContent('contact.content', true);
    @endphp
    <section class="contact-hero-section bg--theme--overlay-2 bg_img bg_fixed" data-background="{{ getImage('assets/images/frontend/contact/' . @$content->data_values->header_background, '1920x825') }}">
        <div class="container">
            <div class="row g-4 justify-content-center">
                <div class="col-md-6 col-lg-4">
                    <div class="contact__item">
                        <div class="contact__icon">
                            <i class="las la-map-marker"></i>
                        </div>
                        <div class="contact__content">
                            <h6 class="contact__title">@lang('Address')</h6>
                            <ul>
                                <li>{{ __(@$content->data_values->address) }}</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="contact__item">
                        <div class="contact__icon">
                            <i class="las la-envelope-open-text"></i>
                        </div>
                        <div class="contact__content">
                            <h6 class="contact__title">@lang('Email Address')</h6>
                            <ul>
                                <li>
                                    <a href="Mailto:{{ $content->data_values->email_one }}">{{ __(@$content->data_values->email_one) }}</a>
                                </li>
                                <li>
                                    <a href="Mailto:{{ $content->data_values->email_two }}">{{ __(@$content->data_values->email_two) }}</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="contact__item">
                        <div class="contact__icon">
                            <i class="las la-mobile-alt"></i>
                        </div>
                        <div class="contact__content">
                            <h6 class="contact__title">@lang('Phone')</h6>
                            <ul>
                                <li>
                                    <a href="Tel:{{ $content->data_values->phone_one }}">{{ $content->data_values->phone_one }}</a>
                                </li>
                                <li>
                                    <a href="Tel:{{ $content->data_values->phone_two }}">{{ $content->data_values->phone_two }}</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="contact-section pt-120 pb-120">
        <div class="container">
            <h3 class="title text--base mb-4 text-center">{{ __(@$content->data_values->form_title) }}</h3>
            <div class="contact-form-wrapper bg--theme--overlay bg_img bg_fixed overflow-hidden" data-background="{{ getImage('assets/images/frontend/contact/' . @$content->data_values->image, '1300x620') }}">
                <form class="contact-form row verify-gcaptcha" method="post" action="">
                    @csrf
                    <div class="form-group col-sm-6">
                        <label class="cmn--label" for="name">@lang('Name')</label>
                        <input class="form-control form--control" name="name" type="text" required>
                    </div>
                    <div class="form-group col-sm-6">
                        <label class="cmn--label" for="email">@lang('Email')</label>
                        <input class="form-control form--control" name="email" type="email" required>
                    </div>
                    <div class="form-group col-sm-12">
                        <label class="cmn--label" for="subject">@lang('Subject')</label>
                        <input class="form-control form--control" name="subject" type="text" value="{{ old('subject') }}" required>
                    </div>
                    <div class="form-group col-sm-12">
                        <label class="cmn--label" for="message">@lang('Message')</label>
                        <textarea class="form-control form--control" name="message" wrap="off" required>{{ old('message') }}</textarea>
                    </div>
                    <x-captcha class="cmn--label" label="Enter captcha bellow" />
                    <div class="col-sm-12 mb-0">
                        <button class="cmn--btn form--control w-100 justify-content-center" type="submit">@lang('SEND MESSAGE')</button>
                    </div>
                </form>
            </div>
        </div>
    </section>
    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif
@endsection
