@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section class="blog-section pt-120 pb-120 bg--section">
        <div class="container">
            <div class="row gy-5 justify-content-center">
                <div class="col-lg-8">
                    <div class="post__details pb-50">
                        <div class="post__header">
                            <h3 class="post__title">
                                {{ __(@$blog->data_values->title) }}
                            </h3>
                        </div>
                        <div class="post__thumb">
                            <img src="{{ getImage('assets/images/frontend/blog/' . @$blog->data_values->image, '820x540') }}" alt="@lang('Blog')">
                        </div>
                        <p class="pb-2">
                            @php echo $blog->data_values->description @endphp
                        </p>
                    </div>
                    <div class="fb-comments" data-href="{{ route('blog.details', [$blog->id, slug($blog->data_values->title)]) }}" data-numposts="5"></div>
                </div>
                <div class="col-lg-4 mrb-30">
                    <aside class="blog-sidebar bg--body">
                        <div class="widget widget__posts">
                            <h5 class="widget__title">@lang('Latest Blogs')</h5>
                            <ul>
                                @foreach ($latestBlogs as $latestBlog)
                                    <li>
                                        <a class="widget__post" href="{{ route('blog.details', [slug(@$latestBlog->data_values->title), $latestBlog->id]) }}">
                                            <div class="widget__post__thumb">
                                                <img src="{{ getImage('assets/images/frontend/blog/' . @$latestBlog->data_values->image) }}" alt="@lang('blog')">
                                            </div>
                                            <div class="widget__post__content">
                                                <h6 class="widget__post__title">
                                                    {{ strLimit($latestBlog->data_values->title, 35) }}
                                                </h6>
                                                <span>{{ showDateTime(@$latestBlog->created_at, $format = 'd F, Y') }}</span>
                                            </div>
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('fbComment')
    @php echo loadExtension('fb-comment') @endphp
@endpush
