@extends('admin.layouts.app')
@section('panel')
    <div class="row gy-4">
        <div class="col-12">
            <div class="row gy-4">

                <div class="col-xxl-3 col-sm-6">
                    <div class="widget-two style--two box--shadow2 b-radius--5 bg--19">
                        <div class="widget-two__icon b-radius--5 bg--primary">
                            <i class="las la-money-bill-wave-alt"></i>
                        </div>
                        <div class="widget-two__content">
                            <h3 class="text-white">{{ showAmount(@$widget['balance'], 8) }} {{ __($general->cur_text) }}</h3>
                            <p class="text-white">@lang('Balance')</p>
                        </div>
                    </div>
                </div>
                <!-- dashboard-w1 end -->

                <div class="col-xxl-3 col-sm-6">
                    <div class="widget-two style--two box--shadow2 b-radius--5 bg--primary">
                        <div class="widget-two__icon b-radius--5 bg--primary">
                            <i class="las la-wallet"></i>
                        </div>
                        <div class="widget-two__content">
                            <h3 class="text-white">{{ showAmount(@$widget['deposits'], 8) }} {{ __($general->cur_text) }}</h3>
                            <p class="text-white">@lang('Deposits')</p>
                        </div>
                    </div>
                </div>
                <!-- dashboard-w1 end -->

                <div class="col-xxl-3 col-sm-6">
                    <div class="widget-two style--two box--shadow2 b-radius--5 bg--1">
                        <div class="widget-two__icon b-radius--5 bg--primary">
                            <i class="fas fa-wallet"></i>
                        </div>
                        <div class="widget-two__content">
                            <h3 class="text-white">{{ showAmount(@$widget['withdrawals'], 8) }} {{ __($general->cur_text) }}</h3>
                            <p class="text-white">@lang('Withdrawals')</p>
                        </div>
                    </div>
                </div>
                <!-- dashboard-w1 end -->

                <div class="col-xxl-3 col-sm-6">
                    <div class="widget-two style--two box--shadow2 b-radius--5 bg--17">
                        <div class="widget-two__icon b-radius--5 bg--primary">
                            <i class="las la-exchange-alt"></i>
                        </div>
                        <div class="widget-two__content">
                            <h3 class="text-white">{{ $widget['referrals'] }}</h3>
                            <p class="text-white">@lang('Referral')</p>
                        </div>
                    </div>
                </div>
                <!-- dashboard-w1 end -->
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card b-radius--10">
                <div class="card-header">
                    <h5 class="title">
                        @lang('Account Details')
                    </h5>
                </div>
                <div class="card-body">

                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between">
                            <strong>@lang('Unique Id')</strong>
                            <span>{{ $account->unique_id }}</span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between">
                            <strong>@lang('Wallet')</strong>
                            <span>{{ $account->unique_id }}</span>
                        </li>

                        @if ($account->ref_by)
                            <li class="list-group-item d-flex justify-content-between">
                                <strong>@lang('Referred By')</strong>

                                <span>
                                    <a href="{{ route('admin.account.detail', $account->ref_by) }}">
                                        {{ $account->referral->unique_id }}
                                    </a>
                                </span>
                            </li>
                        @endif

                        <li class="list-group-item d-flex justify-content-between">
                            <strong>@lang('Status')</strong>
                            @if ($account->status)
                                <span class="badge badge--success">@lang('Activate')</span>
                            @else
                                <span class="badge badge--danger">@lang('Deactivated')</span>
                            @endif
                        </li>
                    </ul>

                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card b-radius--10">
                <div class="card-header">
                    <h5 class="title">@lang('Track Details')</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <strong>@lang('Speed')</strong>
                            <span>{{ $account->track->speed }} @lang('DH/S')</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <strong>@lang('Balance')</strong>
                            <span>{{ getAmount($account->track->balance, 8) }} {{ __($general->cur_text) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <strong>@lang('Withdraw')</strong>
                            <span>{{ getAmount($account->track->withdraw, 8) }} {{ __($general->cur_text) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <strong>@lang('Starts From')</strong>
                            <span>{{ showDateTime($account->track->created_at) }}</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="title d-flex justify-content-between align-items-center">
                        @lang('Latest Deposits')</strong>
                        <a class="btn btn-outline--primary" href="{{ route('admin.deposit.index') }}?search={{ $account->unique_id }}">@lang('View All')</a>
                    </h5>
                </div>

                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th>@lang('Time')</th>
                                    <th>@lang('TRX ID')</th>
                                    <th>@lang('Amount')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($deposits as $item)
                                    <tr>
                                        <td>{{ showDateTime($item->updated_at) }}</td>
                                        <td>{{ $item->trx }}</td>
                                        <td>{{ getAmount($item->amount) }} {{ __($general->cur_text) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="100%">@lang('No deposit yet')</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="title">@lang('Latest Withdrawals')</h5>
                    <a class="btn btn-outline--primary" href="{{ route('admin.withdraw.index') }}?search={{ $account->unique_id }}">@lang('View All')</a>
                </div>

                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th>@lang('Time')</th>
                                    <th>@lang('TRX Id')</th>
                                    <th>@lang('Amount')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($withdrawals as $item)
                                    <tr>
                                        <td>{{ $item->created_at }}</td>
                                        <td>{{ $item->trx }}</td>
                                        <td>{{ getAmount($item->amount) }} {{ __($general->cur_text) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="100%">@lang('No withdrawal yet')</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">

            <div class="card b-radius--10">
                <div class="card-header">
                    <h5 class="title">@lang('Action')</h5>
                </div>
                <div class="card-body">
                    @if ($account->status)
                        <button class="h-45 btn btn--danger w-100 confirmationBtn" data-action="{{ route('admin.account.status', [$account->id, 0]) }}" data-question="@lang('Are you sure deactivated this account?')">@lang('Deactive')</button>
                    @else
                        <button class="h-45 btn btn--success w-100 confirmationBtn" data-action="{{ route('admin.account.status', [$account->id, 1]) }}" data-question="@lang('Are you sure activated this account?')">@lang('Active')</button>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <x-confirmation-modal />
@endsection
