<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Withdrawal;
use Carbon\Carbon;
use Illuminate\Http\Request;

class WithdrawalController extends Controller
{

    public function index(Request $request)
    {
        $pageTitle = 'Withdrawals';
        $withdrawals = Withdrawal::dateFilter()->searchable(['trx', 'account:unique_id'])->latest()->with('account')->paginate(getPaginate());
        return view('admin.withdraw.index', compact('withdrawals', 'pageTitle'));
    }
}
