
<?php $__env->startSection('content'); ?>
    <div class="card custom--card text--white mb-5">
        <div class="card-header py-3">
            <h5 class="card-title m-0"><?php echo e($account->wallet); ?></h5>
        </div>
        <div class="card-body py-5">
            <h4 class="card__dogecoin__balance text--white"><span id="mined"><?php echo e($track->balance); ?></span><?php echo e($general->cur_sym); ?></h4>
        </div>
        <div class="card-footer py-3">
            <span class="card__text">
                <?php echo app('translator')->get('MINER SPEED'); ?>: <span><?php echo e($track->speed); ?></span> <?php echo app('translator')->get('DH/S'); ?> | <?php echo app('translator')->get('DAILY PROFIT'); ?> <span id="dailyProfit"> <?php echo e($track->speed * $general->daily_earning); ?> </span> <?php echo e(__($general->cur_text)); ?> <br>   <?php echo app('translator')->get('Get 3-5% Daily'); ?>
            </span>
        </div>
    </div>

    <?php if($general->referral_system): ?>
        <div class="card custom--card text--white mb-5">
            <div class="card-header py-3">
                <h5 class="card-title m-0"><?php echo app('translator')->get('Your Referral Link'); ?></h5>
            </div>

            <div class="card-body p-lg-5 p-sm-0">
                <div class="form-group m-0">
                    <div class="input-group m-0">
                        <input class="form-control form--control bg-transparent" id="ref" type="url" value="<?php echo e(route('home') . '?reference=' . $account->unique_id); ?>" readonly>
                        <button class="input-group-text bg--base border--light text--white copybtn" data-copytarget="#ref" type="button"><i class="fa fa-copy"></i> &nbsp; <?php echo app('translator')->get('Copy'); ?></button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="<?php if($general->withdraw_system && $general->referral_system): ?> col-md-4 <?php elseif($general->withdraw_system || $general->referral_system): ?> col-md-6  <?php else: ?> col-12 <?php endif; ?>">
            <a class="d-block" href="<?php echo e(route('account.deposit')); ?>">
                <div class="card custom--card text--white mb-5">
                    <div class="card-header py-3">
                        <h5 class="card-title m-0"><?php echo app('translator')->get('Deposits'); ?></h5>
                    </div>
                    <div class="card-body">
                        <span class="digit-count"><?php echo e($depositCount); ?></span>
                        <hr>
                        <p class="digit-amount-label"><?php echo app('translator')->get('Total Deposited'); ?></p>
                        <span class="digit-amount"><?php echo e(getAmount($depositTotal)); ?> <?php echo e(__($general->cur_text)); ?></span>
                    </div>
                </div>
            </a>
        </div>
        <?php if($general->withdraw_system): ?>
            <div class="<?php if($general->referral_system): ?> col-md-4 <?php else: ?> col-md-6 <?php endif; ?>">
                <a class="d-block" href="<?php echo e(route('account.withdraw')); ?>">
                    <div class="card custom--card text--white mb-5">
                        <div class="card-header py-3">
                            <h5 class="card-title m-0"><?php echo app('translator')->get('Withdrawals'); ?></h5>
                        </div>
                        <div class="card-body">
                            <span class="digit-count"><?php echo e($withdrawCount); ?></span>
                            <hr>
                            <p class="digit-amount-label"><?php echo app('translator')->get('Total Witdrawan'); ?></p>
                            <span class="digit-amount d-block"><?php echo e(getAmount($withdrawTotal)); ?> <?php echo e(__($general->cur_text)); ?></span>
                        </div>
                    </div>
                </a>
            </div>
        <?php endif; ?>
        <?php if($general->referral_system): ?>
            <div class="<?php if($general->withdraw_system): ?> col-md-4 <?php else: ?> col-md-6 <?php endif; ?>">
                <a class="d-block" href="<?php echo e(route('account.referrals')); ?>">
                    <div class="card custom--card text--white mb-5">
                        <div class="card-header py-3">
                            <h5 class="card-title m-0"><?php echo app('translator')->get('Referrals'); ?></h5>
                        </div>
                        <div class="card-body">
                            <span class="digit-count"><?php echo e($referralCount); ?></span>
                            <hr>
                            <p class="digit-amount-label"><?php echo app('translator')->get('Total Referral Bonus'); ?></p>
                            <span class="digit-amount"><?php echo e(getAmount($account->referrals->sum('bonus_value'))); ?> <?php echo e(__($general->cur_text)); ?></span>
                        </div>
                    </div>
                </a>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            let dailyProfit = $('#dailyProfit').text();
            let dailyProfitInSeconds = dailyProfit / 864000;

            let minedAmount = <?php echo e($track->balance); ?>;
            setInterval(function() {
                minedAmount += dailyProfitInSeconds;
                $('#mined').text(minedAmount.toFixed(8));
            }, 100);
        })(jQuery);

        document.querySelectorAll('.copybtn').forEach((element) => {
            element.addEventListener('click', copy, true);
        })

        function copy(e) {
            var
                t = e.target,
                c = t.dataset.copytarget,
                inp = (c ? document.querySelector(c) : null);
            if (inp && inp.select) {
                inp.select();
                try {
                    document.execCommand('copy');
                    inp.blur();
                    t.classList.add('copied');
                    setTimeout(function() {
                        t.classList.remove('copied');
                    }, 1500);
                } catch (err) {
                    alert(`<?php echo app('translator')->get('Please press Ctrl/Cmd+C to copy'); ?>`);
                }
            }
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/solana/public_html/core/resources/views/templates/basic/account/dashboard.blade.php ENDPATH**/ ?>