@extends($activeTemplate . 'layouts.master')
@section('content')
    @php
        $content = getContent('user_dashboard.content', true);
    @endphp

    <div class="card custom--card text--white mb-5">
        <div class="card-header py-3">
            <h5 class="card-title m-0">@lang('Your Referral Link')</h5>
        </div>

        <div class="card-body p-lg-5 p-sm-0">
            <div class="form-group m-0">
                <div class="input-group m-0">
                    <input class="form-control form--control bg-transparent" id="ref" type="url" value="{{ route('home') . '?reference=' . $account->unique_id }}" readonly>
                    <button class="input-group-text bg--base border--light text--white copybtn" data-copytarget="#ref" type="button"><i class="fa fa-copy"></i> &nbsp; @lang('Copy')</button>
                </div>
            </div>
        </div>
    </div>
    <div class="active--miners">
        <h4 class="subtitle mb-4 pt-5 text-white">@lang('Your Referral Bonus Log')</h4>
        <div class="table--responsive">
            <table class="cmn--table table--white">
                <thead>
                    <tr>
                        <th>
                            @lang('Time')
                        </th>
                        <th>
                            @lang('Account Id')
                        </th>
                        <th>
                            @lang('Bonus')
                        </th>
                    </tr>
                </thead>

                <tbody>
                    @forelse ($referralLogs as $referral)
                        <tr>
                            <td>
                                {{ showDateTime($referral->created_at) }}
                            </td>
                            <td>
                                <span>{{ @$referral->referral->unique_id }}</span>
                            </td>
                            <td>
                                {{ $referral->bonus_value }} {{ __($general->cur_text) }}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="100%">{{ $emptyMessage }}</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
            @if ($referralLogs->hasPages())
                {{ paginateLinks($referralLogs) }}
            @endif
        </div>
    </div>
@endsection

@push('script')
    <script>
        'use strict';
        document.querySelectorAll('.copybtn').forEach((element) => {
            element.addEventListener('click', copy, true);
        })

        function copy(e) {
            var
                t = e.target,
                c = t.dataset.copytarget,
                inp = (c ? document.querySelector(c) : null);
            if (inp && inp.select) {
                inp.select();
                try {
                    document.execCommand('copy');
                    inp.blur();
                    t.classList.add('copied');
                    setTimeout(function() {
                        t.classList.remove('copied');
                    }, 1500);
                } catch (err) {
                    alert(`@lang('Please press Ctrl/Cmd+C to copy')`);
                }
            }
        }
    </script>
@endpush
