@extends('admin.layouts.app')

@section('panel')
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th>@lang('Start From')</th>
                                    <th>@lang('Account')</th>
                                    <th>@lang('Speed')</th>
                                    <th>@lang('Withdraw')</th>
                                    <th>@lang('Current Balance')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($tracks as $track)
                                    <tr>
                                        <td>{{ showDateTime($track->created_at) }} </td>
                                        <td>
                                            <a href="{{ route('admin.account.detail', $track->account_id) }}">{{ @$track->account->unique_id }}</a>
                                        </td>
                                        <td>{{ $track->speed }} @lang('DH/S')</td>
                                        <td>{{ showAmount($track->withdraw, 8) }} {{ __($general->cur_text) }}</td>
                                        <td>
                                            @php
                                                $diff_in_seconds = Carbon\Carbon::now()->diffInSeconds($track->updated_at);
                                                $daily_earning = $track->speed * $general->daily_earning;
                                                $per_sec_earning = $daily_earning / 86400;
                                                $total = round($diff_in_seconds * $per_sec_earning, 8);
                                                $balance = $track->balance + $total;
                                            @endphp
                                            {{ showAmount($balance, 8) }} {{ __($general->cur_text) }}
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($tracks->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($tracks) }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection
@push('breadcrumb-plugins')
    <x-search-form placeholder="Account"></x-search-form>
@endpush
