<?php

namespace App\Http\Controllers\Admin;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Models\Account;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ManageAccountController extends Controller
{
    public function index()
    {
        $accounts  = $this->getAccounts();
        $pageTitle = 'All Accounts';
        return view('admin.account.index', compact('accounts', 'pageTitle'));
    }

    public function active()
    {
        $accounts  = $this->getAccounts('active');
        $pageTitle = 'Active Accounts';
        return view('admin.account.index', compact('accounts', 'pageTitle'));
    }

    public function referred()
    {
        $accounts  = $this->getAccounts('referred');
        $pageTitle = 'Referred Accounts';
        return view('admin.account.index', compact('accounts', 'pageTitle'));
    }

    public function banned()
    {
        $accounts  = $this->getAccounts('banned');
        $pageTitle = 'Banned Accounts';
        return view('admin.account.index', compact('accounts', 'pageTitle'));
    }

    public function getAccounts($scope = null)
    {
        $accounts  = Account::latest();
        if ($scope) {
            $accounts = $accounts->$scope();
        }

        return $accounts->searchable(['wallet', 'unique_id'], true)->with('track', 'referral')->paginate(getPaginate());
    }

    public function detail($id)
    {
        $account     = Account::with('track', 'referral')->findOrFail($id);
        $deposits    = $account->deposits()->successful()->take(3)->get();
        $withdrawals = $account->withdrawals()->take(3)->get();
        $general     = gs();
        $diff        = Carbon::now()->diffInSeconds($account->track->updated_at);
        $daily       = $account->track->speed * $general->daily;
        $perSec      = $daily / 86400;
        $total       = $diff * $perSec;
        $balance     = $total + $account->track->balance;
        $pageTitle   = 'Details of Wallet Address : ' . $account->wallet;

        $widget['balance']     = $balance;
        $widget['deposits']    = $account->deposits()->successful()->sum('amount');
        $widget['withdrawals'] = $account->track->withdraw;
        $widget['referrals']   = Account::where('ref_by', $account->id)->count();
        return view('admin.account.detail', compact('account', 'pageTitle', 'deposits', 'withdrawals', 'balance', 'widget'));
    }
    public function status(Request $request, $id)
    {
        $user = Account::findOrFail($id);
        if ($user->status == Status::ACCOUNT_ACTIVE) {
            $user->status = Status::ACCOUNT_BAN;
            $notify[] = ['success', 'Account banned successfully'];
        } else {
            $user->status = Status::ACCOUNT_ACTIVE;
            $notify[] = ['success', 'Account unbanned successfully'];
        }
        $user->save();
        return back()->withNotify($notify);
    }
}
