@php
    $content = getContent('transaction.content', true);
    $deposits = \App\Models\Deposit::successful()
        ->latest()
        ->with('account')
        ->take(25)
        ->get();
    $withdrawals = \App\Models\Withdrawal::latest()
        ->with('account')
        ->take(25)
        ->get();
@endphp
<section class="investment-section bg--theme--overlay bg_fixed pt-120 pb-120 bottom--wave-wrapper top--wave-wrapper bg_img" id="transaction" data-background="{{ getImage('assets/images/frontend/transaction/' . @$content->data_values->background_image, '1920x1080') }}">
    <div class="banner-shape-top">
        <img src="{{ asset($activeTemplateTrue . 'images/wave-rev.png') }}" alt="@lang('banner')">
    </div>
    <div class="banner-shape">
        <img src="{{ asset($activeTemplateTrue . 'images/wave.png') }}" alt="@lang('banner')">
    </div>
    <div class="container">
        <div class="section__header section__header__center text--white">
            <span class="section__cate">{{ __(@$content->data_values->title) }}</span>
            <h3 class="text--white pb-3">{{ __(@$content->data_values->subtitle) }}</h3>
            <p>{{ __(@$content->data_values->description) }}</p>
        </div>
        <ul class="nav nav-tabs nav--tabs">
            <li class="nav-item">
                <a class="nav-link active" data-bs-toggle="tab" href="#deposit">@lang('Deposit')</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#withdraw">@lang('Withdraw')</a>
            </li>
        </ul>
        <div class="tab-content">
            <div class="tab-pane fade show active" id="deposit">
                <div class="table--responsive">
                    <table class="cmn--table table--white">
                        <thead>
                            <tr>
                                <th>@lang('Amount')</th>
                                <th>@lang('Wallet')</th>
                                <th>@lang('Time')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($deposits as $deposit)
                                <tr>
                                    <td>
                                        {{ showAmount($deposit->amount) }} {{ __($general->cur_text) }}
                                    </td>
                                    <td>
                                        @php echo substr_replace(@$deposit->account->wallet, 'xxx', -3) @endphp
                                    </td>
                                    <td>
                                        {{ showDateTime($deposit->updated_at) }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="tab-pane fade" id="withdraw">
                <div class="table--responsive">
                    <table class="cmn--table table--white">
                        <thead>
                            <tr>
                                <th>@lang('Amount')</th>
                                <th>@lang('Wallet')</th>
                                <th>@lang('Time')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($withdrawals as $withdrawal)
                                <tr>
                                    <td>
                                        {{ showAmount($withdrawal->amount) }} {{ __($general->cur_text) }}
                                    </td>
                                    <td>
                                        @php echo substr_replace(@$withdrawal->account->wallet, '<b>xxx</b>', -3) @endphp
                                    </td>
                                    <td>
                                        {{ showDateTime($withdrawal->updated_at) }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>
