@php
    $content = getContent('top_investor.content', true);
    $topInvestor = App\Models\Deposit::where('status', 1)
        ->groupBy('account_id')
        ->selectRaw('id, account_id, wallet,SUM(amount) as amount')
        ->with('account')
        ->limit(6)
        ->latest('amount')
        ->get();
@endphp

<section class="investor-section pt-120 pb-120">
    <div class="container">
        <div class="section__header section__header__center">
            <span class="section__cate">
                {{ __(@$content->data_values->title) }}
            </span>
            <h3 class="section__title">{{ __(@$content->data_values->subtitle) }}</h3>
            <p>{{ __(@$content->data_values->description) }}</p>
        </div>
        <div class="row g-4">
            @foreach ($topInvestor as $investor)
                <div class="col-xl-4 col-md-6">
                    <div class="investor__item">
                        <div class="investor__thumb">
                            <img src="{{ getImage('assets/images/frontend/top_investor/' . @$content->data_values->image, '100x100') }}" alt="@lang('investor')">
                        </div>

                        <div class="investor__content">
                            <h6 class="investor__title">{{ strLimit($investor->account->wallet, 8) }}</h6>
                            <span class="total__invest"><span class="text--success">{{ getAmount($investor->amount, 8) }}</span> {{ __($general->cur_text) }}</span>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
