@php
    $content = getContent('partners.content', true);
    $partners = getContent('partners.element', false, null, true);
@endphp

<div class="partners-section pt-120 pb-120">
    <div class="container">
        <div class="section__header section__header__center">
            <span class="section__cate">{{ __(@$content->data_values->title) }}</span>
            <h3 class="section__title">{{ __(@$content->data_values->subtitle) }}</h3>
            <p>{{ __(@$content->data_values->description) }}</p>
        </div>
        <div class="partner-slider owl-theme owl-carousel">
            @foreach ($partners as $item)
                <a class="partner-thumb" href="javascript:void(0)">
                    <img src="{{ getImage('assets/images/frontend/partners/' . @$item->data_values->image, '125x45') }}" alt="@lang('partner')">
                    <img src="{{ getImage('assets/images/frontend/partners/' . @$item->data_values->image, '125x45') }}" alt="@lang('partner')">
                </a>
            @endforeach
        </div>
    </div>
</div>
