@php
    $content = getContent('faq.content', true);
    $faqs = getContent('faq.element', false, null, true);
@endphp

<section class="faqs-section pt-120 pb-120" id="faq">
    <div class="container">
        <div class="section__header section__header__center">
            <span class="section__cate">{{ __(@$content->data_values->title) }}</span>
            <h3 class="section__title">{{ __(@$content->data_values->subtitle) }}</h3>
            <p>{{ __(@$content->data_values->description) }}</p>
        </div>
        <div class="row justify-content-center gy-3">
            <div class="col-lg-6">
                <div class="faq__wrapper">
                    @foreach ($faqs as $key => $faq)
                        @if ($loop->odd)
                            <div class="faq__item">
                                <div class="faq__title">
                                    <h5 class="title">{{ __(@$faq->data_values->question) }}</h5>
                                    <span class="right-icon"></span>
                                </div>
                                <div class="faq__content">
                                    <p>{{ __(@$faq->data_values->answer) }}</p>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
            <div class="col-lg-6">
                <div class="faq__wrapper">
                    @foreach ($faqs as $key => $faq)
                        @if ($loop->even)
                            <div class="faq__item">
                                <div class="faq__title">
                                    <h5 class="title">{{ __(@$faq->data_values->question) }}</h5>
                                    <span class="right-icon"></span>
                                </div>
                                <div class="faq__content">
                                    <p>{{ __(@$faq->data_values->answer) }}</p>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
