@php
    $bannerContent = getContent('banner.content', true);
@endphp

<section class="banner-section bg--theme--overlay">
    <div class="shapes-banner bg_img" data-background="{{ getImage('assets/images/frontend/banner/' . @$bannerContent->data_values->background_image, '1920x875') }}"></div>
    <div class="particles-js" id="particles-js"></div>

    <div class="banner-shape">
        <img src="{{ asset($activeTemplateTrue . 'images/wave.png') }}" alt="@lang('banner')">
    </div>

    <div class="doge1 d-none d-lg-block">
        <img src="{{ getImage('assets/images/frontend/banner/' . @$bannerContent->data_values->image, '210x210') }}" alt="@lang('doge1')">
    </div>
    <div class="doge2 d-none d-lg-block">
        <img src="{{ getImage('assets/images/frontend/banner/' . @$bannerContent->data_values->image, '210x210') }}" alt="@lang('doge2')">
    </div>
    <div class="container">
        <div class="banner__content text--white">
            <h4 class="banner__category text--white">{{ __(@$bannerContent->data_values->title) }}</h4>
            <h1 class="banner__title text--white">{{ __(@$bannerContent->data_values->subtitle) }}</h1>
            <p class="banner__text">{{ __(@$bannerContent->data_values->description) }}</p>
        </div>
        <div class="banner__bottom__content text--white">
            <div class="row justify-content-center">
                <div class="col-lg-7 col-md-10">
                    <form class="account__form" id="loginForm" action="#">
                        @csrf
                        <div class="form-group position-relative">
                            <input class="form-control" name="wallet" type="text" placeholder="@lang('Your Dogecoin Wallet Address')">
                            <button class="cmn--btn" type="submit">@lang('ENTER')</button>
                        </div>
                    </form>
                    <h4 class="dogecoin__amount text--white"><span id="mined">0</span> {{ __($general->cur_text) }}</h4>
                    <p class="banner__bottom__text">
                        @lang('MINER SPEED'): <span>{{ $general->free_dhs }}</span> @lang('DH/S') | @lang('DAILY PROFIT') <span id="dailyProfit"> {{ $general->free_dhs * $general->daily_earning }} </span> {{ __($general->cur_text) }}
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

@push('script-lib')
    <script src="{{ asset($activeTemplateTrue . '/js/particles.min.js') }}"></script>
    <script src="{{ $activeTemplateTrue . '/js/particle.js' }}"></script>
@endpush

@push('script')
    <script>
        'use strict';
        (function($) {
            let dailyProfit = $('#dailyProfit').text();
            let dailyProfitInSeconds = dailyProfit / 864000;
            let minedAmount = 0;
            setInterval(function() {
                minedAmount += dailyProfitInSeconds;
                $('#mined').text(minedAmount.toFixed(8));
            }, 100);
            $('#loginForm').on('submit', function(e) {
                e.preventDefault();
                var data = $(this).serialize();
                var wallet = $(this).find('[name=wallet]').val();
                if (!wallet) {
                    notify('error', 'Wallet address is required')
                    return;
                }

                $.ajax({
                    type: "POST",
                    url: "{{ route('account.login') }}",
                    data: data,
                    dataType: "json",
                    success: function(response) {
                        if (response.error) {
                            notify('error', response.error)
                        } else {
                            notify('success', response.success)
                            setTimeout(function() {
                                window.location.href = "{{ route('account.home') }}";
                            }, 1000)
                        }
                    },
                    error: function(response) {
                        notify('warning', "The page is reloading to refresh the session.")
                        notify('error', "Session not found.")
                        setInterval(() => {
                            location.reload()
                        }, 2000);
                    }
                });
            })
            initParticles(`{{ getImage(getFilePath('logoIcon') . '/logo.png') }}`);
        })(jQuery)
    </script>
@endpush
