@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="card custom--card text--white mb-5">
        <div class="card-header py-3">
            <h5 class="card-title m-0">{{ $account->wallet }}</h5>
        </div>
        <div class="card-body py-5">
            <h4 class="card__dogecoin__balance text--white"><span id="mined">{{ $track->balance }}</span>{{ $general->cur_sym }}</h4>
        </div>
        <div class="card-footer py-3">
            <span class="card__text">
                @lang('MINER SPEED'): <span>{{ $track->speed }}</span> @lang('DH/S') | @lang('DAILY PROFIT') <span id="dailyProfit"> {{ $track->speed * $general->daily_earning }} </span> {{ __($general->cur_text) }}
            </span>
        </div>
    </div>

    @if ($general->referral_system)
        <div class="card custom--card text--white mb-5">
            <div class="card-header py-3">
                <h5 class="card-title m-0">@lang('Your Referral Link')</h5>
            </div>

            <div class="card-body p-lg-5 p-sm-0">
                <div class="form-group m-0">
                    <div class="input-group m-0">
                        <input class="form-control form--control bg-transparent" id="ref" type="url" value="{{ route('home') . '?reference=' . $account->unique_id }}" readonly>
                        <button class="input-group-text bg--base border--light text--white copybtn" data-copytarget="#ref" type="button"><i class="fa fa-copy"></i> &nbsp; @lang('Copy')</button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <div class="row">
        <div class="@if ($general->withdraw_system && $general->referral_system) col-md-4 @elseif ($general->withdraw_system || $general->referral_system) col-md-6  @else col-12 @endif">
            <a class="d-block" href="{{ route('account.deposit') }}">
                <div class="card custom--card text--white mb-5">
                    <div class="card-header py-3">
                        <h5 class="card-title m-0">@lang('Deposits')</h5>
                    </div>
                    <div class="card-body">
                        <span class="digit-count">{{ $depositCount }}</span>
                        <hr>
                        <p class="digit-amount-label">@lang('Total Deposited')</p>
                        <span class="digit-amount">{{ getAmount($depositTotal) }} {{ __($general->cur_text) }}</span>
                    </div>
                </div>
            </a>
        </div>
        @if ($general->withdraw_system)
            <div class="@if ($general->referral_system) col-md-4 @else col-md-6 @endif">
                <a class="d-block" href="{{ route('account.withdraw') }}">
                    <div class="card custom--card text--white mb-5">
                        <div class="card-header py-3">
                            <h5 class="card-title m-0">@lang('Withdrawals')</h5>
                        </div>
                        <div class="card-body">
                            <span class="digit-count">{{ $withdrawCount }}</span>
                            <hr>
                            <p class="digit-amount-label">@lang('Total Witdrawan')</p>
                            <span class="digit-amount d-block">{{ getAmount($withdrawTotal) }} {{ __($general->cur_text) }}</span>
                        </div>
                    </div>
                </a>
            </div>
        @endif
        @if ($general->referral_system)
            <div class="@if ($general->withdraw_system) col-md-4 @else col-md-6 @endif">
                <a class="d-block" href="{{ route('account.referrals') }}">
                    <div class="card custom--card text--white mb-5">
                        <div class="card-header py-3">
                            <h5 class="card-title m-0">@lang('Referrals')</h5>
                        </div>
                        <div class="card-body">
                            <span class="digit-count">{{ $referralCount }}</span>
                            <hr>
                            <p class="digit-amount-label">@lang('Total Referral Bonus')</p>
                            <span class="digit-amount">{{ getAmount($account->referrals->sum('bonus_value')) }} {{ __($general->cur_text) }}</span>
                        </div>
                    </div>
                </a>
            </div>
        @endif
    </div>
@endsection

@push('script')
    <script>
        'use strict';
        (function($) {
            let dailyProfit = $('#dailyProfit').text();
            let dailyProfitInSeconds = dailyProfit / 864000;

            let minedAmount = {{ $track->balance }};
            setInterval(function() {
                minedAmount += dailyProfitInSeconds;
                $('#mined').text(minedAmount.toFixed(8));
            }, 100);
        })(jQuery);

        document.querySelectorAll('.copybtn').forEach((element) => {
            element.addEventListener('click', copy, true);
        })

        function copy(e) {
            var
                t = e.target,
                c = t.dataset.copytarget,
                inp = (c ? document.querySelector(c) : null);
            if (inp && inp.select) {
                inp.select();
                try {
                    document.execCommand('copy');
                    inp.blur();
                    t.classList.add('copied');
                    setTimeout(function() {
                        t.classList.remove('copied');
                    }, 1500);
                } catch (err) {
                    alert(`@lang('Please press Ctrl/Cmd+C to copy')`);
                }
            }
        }
    </script>
@endpush
