@extends('admin.layouts.app')
@section('panel')
    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive--md table-responsive">
                <table class="table--light style--two table">
                    <thead>
                        <tr>
                            <th>@lang('Deposited By')</th>
                            <th>@lang('Bonus Received By')</th>
                            <th>@lang('Deposit Amount')</th>
                            <th>@lang('Bonus Amount')</th>
                        </tr>
                    </thead>
                    <tbody class="list">
                        @forelse ($referralLog as $log)
                            <tr>
                                <td>
                                    <a class="text--base" href="{{ route('admin.account.detail', $log->referral->id) }}">{{ @$log->referral->unique_id }}</a>
                                </td>

                                <td>
                                    <a href="{{ route('admin.account.detail', @$log->account->id) }}">{{ @$log->account->unique_id }}</a>
                                </td>
                                <td>{{ showAmount(@$log->deposit_amount, 8) }} {{ __($general->cur_text) }}</td>
                                <td><strong>{{ showAmount($log->bonus_value, 8) }} {{ __($general->cur_text) }}</strong></td>
                            </tr>

                        @empty
                            <tr>
                                <td class="text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if ($referralLog->hasPages())
            <div class="card-footer py-4">
                {{ paginateLinks($referralLog) }}
            </div>
        @endif
    </div>
@endsection
@push('breadcrumb-plugins')
    <x-search-form dateSearch='yes' placeholder="Bonus Received By" />
@endpush
