@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10">
                <div class="card-body">
                    <div class="card-title alert alert-primary p-3" role="alert">
                        @lang('This system uses the "<b>Coinpayment</b>" gateway for both deposit and withdrawal')
                    </div>

                    <form action="{{ route('admin.gateway.update') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="form-group col-xl-12">
                                <label for="key1">@lang('Public Key')</label>
                                <input class="form-control" id="key1" name="public_key" type="text" value="{{ old('public_key', $gateway->key_1) }}">
                            </div>

                            <div class="form-group col-xl-12">
                                <label for="key2">@lang('Private Key')</label>
                                <input class="form-control" id="key2" name="private_key" type="text" value="{{ old('private_key', $gateway->key_2) }}">
                            </div>

                            <div class="form-group col-lg-6 col-xxl-4">
                                <label for="minimum_deposit">@lang('Minimum Deposit Limit')</label>
                                <div class="input-group">
                                    <input class="form-control form-control-lg" id="minimum_deposit" id="min-limit" name="minimum_deposit_limit" type="text" value="{{ old('minimum_deposit_limit', $gateway->minimum_deposit) }}">
                                    <span class="input-group-text">{{ __($general->cur_text) }}</span>
                                </div>
                            </div>
                            <div class="form-group col-lg-6 col-xxl-4">
                                <label for="minimum_withdrawal_limit">@lang('Minimum Withdrawal Limit')</label>
                                <div class="input-group">
                                    <input class="form-control form-control-lg" id="minimum_withdrawal_limit" name="minimum_withdrawal_limit" type="text" value="{{ old('minimum_withdrawal_limit', $gateway->minimum_withdraw) }}">
                                    <span class="input-group-text">{{ __($general->cur_text) }}</span>
                                </div>
                            </div>

                            <div class="form-group col-lg-6 col-xxl-4">
                                <label for="maximum_withdrawal_limit">@lang('Maximum Withdrawal Limit')</label>
                                <div class="input-group">
                                    <input class="form-control form-control-lg" id="maximum_withdrawal_limit" name="maximum_withdrawal_limit" type="text" value="{{ old('maximum_withdrawal_limit', $gateway->maximum_withdraw) }}">
                                    <span class="input-group-text">{{ __($general->cur_text) }}</span>
                                </div>
                            </div>
                        </div>
                        <button class="btn btn--primary h-45 w-100" type="submit">@lang('Update')</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
