@extends('admin.layouts.app')

@section('panel')
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th scope="col">@lang('Date')</th>
                                    <th scope="col">@lang('Trx Number')</th>
                                    <th scope="col">@lang('Wallet')</th>
                                    <th scope="col">@lang('Account')</th>
                                    @if (!request()->routeIs('admin.deposit.initiated'))
                                        <th scope="col">@lang('Amount')</th>
                                    @endif
                                    @if (request()->routeIs('admin.deposit.index'))
                                        <th scope="col">@lang('Status')</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($deposits as $deposit)
                                    <tr>
                                        <td> {{ showDateTime($deposit->created_at) }}</td>
                                        <td class="fw-bold text-uppercase">{{ $deposit->trx }}</td>
                                        <td>{{ $deposit->wallet }}</td>
                                        <td><a href="{{ route('admin.account.detail', $deposit->account_id) }}">{{ @$deposit->account->unique_id }}</a></td>
                                        @if (!request()->routeIs('admin.deposit.initiated'))
                                            <td class="fw-bold">
                                                @if ($deposit->status)
                                                    {{ showAmount($deposit->amount, 8) }} {{ __($general->cur_text) }}
                                                @else
                                                    --
                                                @endif
                                            </td>
                                        @endif
                                        @if (request()->routeIs('admin.deposit.index'))
                                            <td>
                                                @php
                                                    echo $deposit->statusBadge;
                                                @endphp
                                            </td>
                                        @endif
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($deposits->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($deposits) }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-search-form dateSearch='yes' placeholder="TRX / Wallet / Account" />
@endpush
