@extends('admin.layouts.app')

@section('panel')
    @if (@json_decode($general->system_info)->version > systemDetails()['version'])
        <div class="row">
            <div class="col-md-12">
                <div class="card bg-warning mb-3 text-white">
                    <div class="card-header">
                        <h3 class="card-title"> @lang('New Version Available') <button class="btn btn--dark float-end">@lang('Version') {{ json_decode($general->system_info)->version }}</button> </h3>
                    </div>
                    <div class="card-body">
                        <h5 class="card-title text-dark">@lang('What is the Update ?')</h5>
                        <p>
                            <pre class="f-size--24">{{ json_decode($general->system_info)->details }}</pre>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    @endif
    @if (@json_decode($general->system_info)->message)
        <div class="row">
            @foreach (json_decode($general->system_info)->message as $msg)
                <div class="col-md-12">
                    <div class="alert border--primary border" role="alert">
                        <div class="alert__icon bg--primary"><i class="far fa-bell"></i></div>
                        <p class="alert__message">@php echo $msg; @endphp</p>
                        <button class="close" data-bs-dismiss="alert" type="button" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                </div>
            @endforeach
        </div>
    @endif

    <div class="row gy-4">
        <div class="col-xxl-3 col-sm-6">
            <div class="card bg--primary has-link box--shadow2 overflow-hidden">
                <a class="item-link" href="{{ route('admin.account.index') }}"></a>
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-4">
                            <i class="las la-users f-size--56"></i>
                        </div>
                        <div class="col-8 text-end">
                            <span class="text--small text-white">@lang('Total Account')</span>
                            <h2 class="text-white">{{ $account['total_account'] }}</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-3 col-sm-6">
            <div class="card bg--success has-link box--shadow2">
                <a class="item-link" href="{{ route('admin.account.active') }}"></a>
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-4">
                            <i class="las la-user-check f-size--56"></i>
                        </div>
                        <div class="col-8 text-end">
                            <span class="text--small text-white">@lang('Active Account')</span>
                            <h2 class="text-white">{{ $account['active_account'] }}</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <div class="card bg--danger has-link box--shadow2">
                <a class="item-link" href="{{ route('admin.account.banned') }}"></a>
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-4">
                            <i class="las la-ban f-size--56"></i>
                        </div>
                        <div class="col-8 text-end">
                            <span class="text--small text-white">@lang('Banned Account')</span>
                            <h2 class="text-white">{{ $account['banned_account'] }}</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <div class="card bg--10 has-link box--shadow2">
                <a class="item-link" href="{{ route('admin.account.referred') }}"></a>
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-4">
                            <i class="las la-user-friends f-size--56"></i>
                        </div>
                        <div class="col-8 text-end">
                            <span class="text--small text-white">@lang('Referred Account')</span>
                            <h2 class="text-white">{{ $account['referred_account'] }}</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- dashboard-w1 end -->
    </div><!-- row end-->
    <!--  widget -->
    <div class="row gy-4 mt-2">
        <div class="col-xxl-3 col-sm-6">
            <div class="widget-two box--shadow2 b-radius--5 bg--white">
                <i class="las la-wallet overlay-icon text--info"></i>
                <div class="widget-two__icon b-radius--5 bg--info">
                    <i class="las la-wallet"></i>
                </div>
                <div class="widget-two__content">
                    <h3>{{ showAmount($payment['total_deposit_amount']) }} {{ __($general->cur_text) }}</h3>
                    <p>@lang('Total Deposited')</p>
                </div>
                <a class="widget-two__btn border--info btn-outline--info border" href="{{ route('admin.deposit.index') }}">@lang('View All')</a>
            </div>
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <div class="widget-two box--shadow2 b-radius--5 bg--white">
                <i class="las la-money-bill overlay-icon text--primary"></i>
                <div class="widget-two__icon b-radius--5 bg--primary">
                    <i class="las la-money-bill"></i>
                </div>
                <div class="widget-two__content">
                    <h3>{{ showAmount($paymentWithdraw['total_withdraw_amount']) }} {{ __($general->cur_text) }}</h3>
                    <p>@lang('Total Withdrawn')</p>
                </div>
                <a class="widget-two__btn border--primary btn-outline--primary border" href="{{ route('admin.withdraw.index') }}">@lang('View All')</a>
            </div>
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <div class="widget-two box--shadow2 b-radius--5 bg--white">
                <i class="las la-hammer overlay-icon text--success"></i>
                <div class="widget-two__icon b-radius--5 bg--success">
                    <i class="las la-hammer"></i>
                </div>
                <div class="widget-two__content">
                    <h3>{{ showAmount($account['track_balance']) }} {{ __($general->cur_text) }}</h3>
                    <p>@lang('Mining Track Balance')</p>
                </div>
                <a class="widget-two__btn border--success btn-outline--success border" href="{{ route('admin.mining.track') }}">@lang('View All')</a>
            </div>
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <div class="widget-two box--shadow2 b-radius--5 bg--white">
                <i class="las la-users overlay-icon text--dark"></i>
                <div class="widget-two__icon b-radius--5 bg--dark">
                    <i class="las la-users"></i>
                </div>
                <div class="widget-two__content">
                    <h3> {{ showAmount($account['referral_bonus']) }} {{ __($general->cur_text) }}</h3>
                    <p>@lang('Referral Bonus')</p>
                </div>
                <a class="widget-two__btn border--dark btn-outline--dark border" href="{{ route('admin.referral.log') }}">@lang('View All')</a>
            </div>
        </div><!-- dashboard-w1 end -->
    </div><!-- row end-->

    <div class="row mb-none-30 mt-30">
        <div class="col-xl-6 mb-30">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">@lang('Deposit & Withdraw  Report of Last 12 Months')</h5>
                    <div id="apex-bar-chart"> </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6 mb-30">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">@lang('Last 30 days Withdraw History')</h5>
                    <div id="withdraw-line"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-none-30 mt-5">
        <div class="col-xl-6 mb-30">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">@lang('Latest Accounts')</h6>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th>@lang('Unique ID')</th>
                                    <th>@lang('Wallet')</th>
                                    <th>@lang('Referred By')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($latestAccounts as $account)
                                    <tr>
                                        <td data-label="@lang('Unique ID')">
                                            <a href="{{ route('admin.account.detail', $account->id) }}">{{ $account->unique_id }}</a>
                                        </td>
                                        <td data-label="@lang('Wallet')">{{ $account->wallet }}</td>

                                        <td data-label="@lang('Referred By')">
                                            @if ($account->ref_by)
                                                <a href="{{ route('admin.account.detail', $account->ref_by) }}">
                                                    {{ $account->referral->unique_id }}
                                                </a>
                                            @else
                                                @lang('N/A')
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6 mb-30">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">@lang('Latest Deposits')</h6>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th>@lang('Unique ID')</th>
                                    <th>@lang('Wallet')</th>
                                    <th>@lang('Amount')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($latestDeposits as $deposit)
                                    <tr>
                                        <td data-label="@lang('Unique ID')">
                                            <a href="{{ route('admin.account.detail', $deposit->account->id) }}">{{ @$deposit->account->unique_id }}</a>
                                        </td>
                                        <td data-label="@lang('Wallet')">{{ $deposit->wallet }}</td>
                                        <td data-label="@lang('Amount')">{{ showAmount($deposit->amount) }} {{ __($general->cur_text) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('admin.partials.cron_instruction')
@endsection

@push('script-lib')
    <script src="{{ asset('assets/admin/js/vendor/apexcharts.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/vendor/chart.js.2.8.0.js') }}"></script>
@endpush

@push('script')
    <script>
        "use strict";
        var options = {
            series: [{
                name: 'Total Deposit',
                data: [
                    @foreach ($months as $month)
                        {{ getAmount(@$depositsMonth->where('months', $month)->first()->depositAmount) }},
                    @endforeach
                ]
            }, {
                name: 'Total Withdraw',
                data: [
                    @foreach ($months as $month)
                        {{ getAmount(@$withdrawalMonth->where('months', $month)->first()->withdrawAmount) }},
                    @endforeach
                ]
            }],
            chart: {
                type: 'bar',
                height: 400,
                toolbar: {
                    show: false
                }
            },
            plotOptions: {
                bar: {
                    horizontal: false,
                    columnWidth: '50%',
                    endingShape: 'rounded'
                },
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                show: true,
                width: 2,
                colors: ['transparent']
            },
            xaxis: {
                categories: @json($months),
            },
            yaxis: {
                title: {
                    text: "{{ __($general->cur_sym) }}",
                    style: {
                        color: '#7c97bb'
                    }
                }
            },
            grid: {
                xaxis: {
                    lines: {
                        show: false
                    }
                },
                yaxis: {
                    lines: {
                        show: false
                    }
                },
            },
            fill: {
                opacity: 1
            },
            tooltip: {
                y: {
                    formatter: function(val) {
                        return "{{ __($general->cur_sym) }}" + val + " "
                    }
                }
            }
        };

        var chart = new ApexCharts(document.querySelector("#apex-bar-chart"), options);
        chart.render();


        // apex-line chart
        var options = {
            chart: {
                height: 400,
                type: "area",
                toolbar: {
                    show: false
                },
                dropShadow: {
                    enabled: true,
                    enabledSeries: [0],
                    top: -2,
                    left: 0,
                    blur: 10,
                    opacity: 0.08
                },
                animations: {
                    enabled: true,
                    easing: 'linear',
                    dynamicAnimation: {
                        speed: 1000
                    }
                },
            },
            dataLabels: {
                enabled: false
            },
            series: [{
                name: "Series 1",
                data: @json($withdrawals['per_day_amount']->flatten())
            }],
            fill: {
                type: "gradient",
                gradient: {
                    shadeIntensity: 1,
                    opacityFrom: 0.7,
                    opacityTo: 0.9,
                    stops: [0, 90, 100]
                }
            },
            xaxis: {
                categories: @json($withdrawals['per_day']->flatten())
            },
            grid: {
                padding: {
                    left: 5,
                    right: 5
                },
                xaxis: {
                    lines: {
                        show: false
                    }
                },
                yaxis: {
                    lines: {
                        show: false
                    }
                },
            },
        };

        var chart = new ApexCharts(document.querySelector("#withdraw-line"), options);

        chart.render();
    </script>
@endpush
@push('breadcrumb-plugins')
    @if ($general->last_cron)
        <div class="d-flex justify-content-end align-items-center flex-wrap gap-2">
            <a class="btn @if (Carbon\Carbon::parse($general->last_cron)->diffInSeconds() < 300) btn--success @elseif(Carbon\Carbon::parse($general->last_cron)->diffInSeconds() < 900) btn--warning @else btn--danger @endif" href="javascript:void(0)"><i class="fa fa-fw fa-clock"></i>@lang('Last Cron Run') : {{ Carbon\Carbon::parse($general->last_cron)->difFforHumans() }}</a>
        </div>
    @endif
@endpush
