<?php

namespace App\Http\Controllers;

use App\Constants\Status;
use App\Models\Track;

class CronController extends Controller
{

    public function cron()
    {
        $general = gs();

        $general->last_cron = now()->toDateTimeString();
        $general->save();

        $tracks = Track::where('status', Status::ACTIVE)->get();

        foreach ($tracks as $track) {
            $diff_in_seconds = now()->diffInSeconds($track->updated_at);
            $daily_earning   = $track->speed * $general->daily_earning;
            $per_sec_earning = $daily_earning / 86400;
            $total           = round($diff_in_seconds * $per_sec_earning, 8);
            $track->balance += $total;
            $track->save();
        }
        return 'CRON Executed.';
    }
}
