<!doctype html>
<html lang="<?php echo e(config('app.locale')); ?>" itemscope itemtype="http://schema.org/WebPage">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> <?php echo e($general->siteName(__($customPageTitle ?? $pageTitle))); ?></title>

    <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
    <link href="<?php echo e(asset('assets/global/css/all.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/global/css/line-awesome.min.css')); ?>" rel="stylesheet" />

    <link href="<?php echo e(asset($activeTemplateTrue . 'css/owl.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset($activeTemplateTrue . 'css/bootstrap-fileinput.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset($activeTemplateTrue . 'css/main.css')); ?>" rel="stylesheet">
    
    <link href="<?php echo e(asset($activeTemplateTrue . 'css/color.php')); ?>?color=<?php echo e($general->base_color); ?>&secondColor=<?php echo e($general->secondary_color); ?>" rel="stylesheet">
    <?php echo $__env->yieldPushContent('style-lib'); ?>
    <?php echo $__env->yieldPushContent('style'); ?>
</head>

<body>
    <?php echo $__env->yieldPushContent('fbComment'); ?>

 

    
    <div class="cursor"></div>
    <div class="overlay"></div>

    <?php echo $__env->yieldContent('app'); ?>

    <?php
        $cookie = App\Models\Frontend::where('data_keys', 'cookie.data')->first();
    ?>
    <?php if($cookie->data_values->status == 1 && !\Cookie::get('gdpr_cookie')): ?>
        <div class="cookies-card hide text-center">
            <div class="cookies-card__icon bg--base">
                <i class="las la-cookie-bite"></i>
            </div>
            <p class="cookies-card__content mt-4"><?php echo e(__($cookie->data_values->short_desc)); ?> <a href="<?php echo e(route('cookie.policy')); ?>" target="_blank"><?php echo app('translator')->get('learn more'); ?></a></p>
            <div class="cookies-card__btn mt-4">
                <a class="btn btn--base w-100 policy" href="javascript:void(0)"><?php echo app('translator')->get('Allow'); ?></a>
            </div>
        </div>
    <?php endif; ?>

    <script src="<?php echo e(asset('assets/global/js/jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/bootstrap.bundle.min.js')); ?>"></script>

    <?php echo $__env->yieldPushContent('script-lib'); ?>
    <?php echo $__env->yieldPushContent('script'); ?>
    <?php echo $__env->make('partials.plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script src="<?php echo e(asset($activeTemplateTrue . '/js/owl.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue . '/js/main.js')); ?>"></script>

    <script>
        (function($) {
            "use strict";
            $(".langSel").on("change", function() {
                window.location.href = "<?php echo e(route('home')); ?>/change/" + $(this).val();
            });

            $('.policy').on('click', function() {
                $.get('<?php echo e(route('cookie.accept')); ?>', function(response) {
                    $('.cookies-card').addClass('d-none');
                });
            });

            setTimeout(function() {
                $('.cookies-card').removeClass('hide')
            }, 2000);

            var inputElements = $('input,[type=text],select,textarea');
            $.each(inputElements, function(index, element) {
                element = $(element);
                element.closest('.form-group').find('label').attr('for', element.attr('name'));
                element.attr('id', element.attr('name'))
            });

            $('.showFilterBtn').on('click', function() {
                $('.responsive-filter-card').slideToggle();
            });
        })(jQuery);
    </script>

        <!-- Floating Action Button Section Starts Here -->
<div class="floating-button-bar">
    <a href="<?php echo e(route('account.deposit')); ?>" class="floating-btn">
        <i class="las la-wallet"></i>
        <span><?php echo app('translator')->get('Deposit'); ?></span>
    </a>
    <a href="<?php echo e(route('account.referrals')); ?>" class="floating-btn">
        <i class="las la-baby"></i>
        <span><?php echo app('translator')->get('Referral'); ?></span>
    </a>
    <a href="<?php echo e(route('account.home')); ?>" class="floating-btn">
        <i class="las la-home"></i>
        <span><?php echo app('translator')->get('Home'); ?></span>
    </a>
    <a href="https://www.digibyte.org/docs/infopaper.pdf" class="floating-btn">
        <i class="las la-credit-card"></i>
        <span><?php echo app('translator')->get('Paper'); ?></span>
    </a>
    <a href="<?php echo e(route('account.logout')); ?>" class="floating-btn">
        <i class="las la-sign-out-alt"></i>
        <span><?php echo app('translator')->get('Logout'); ?></span>
    </a>
    <!-- Support Button -->
    <a href="https://wa.me/77777777" target="_blank" class="floating-support-btn">
        <i class="las la-headset"></i>
        <span><?php echo app('translator')->get('Support'); ?></span>
    </a>
</div>
<!-- Floating Action Button Section Ends Here -->


<style>
.floating-button-bar {
    position: fixed;
    bottom: 20px;
    left: 50%;
    transform: translateX(-50%);
    display: flex;
    background: #fff;
    border-radius: 30px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    padding: 10px 15px;
    z-index: 9999;
}

.floating-btn, .floating-support-btn {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    margin: 0 10px;
    text-decoration: none;
    color: #333;
    font-size: 12px;
}

.floating-btn i, .floating-support-btn i {
    font-size: 24px;
    margin-bottom: 5px;
}

.floating-btn span, .floating-support-btn span {
    display: block;
}

.floating-support-btn {
    background-color: #006097;
    color: #fff;
    border-radius: 50px;
    padding: 10px 15px;
    transition: background-color 0.3s, transform 0.3s;
}

.floating-support-btn:hover {
    background-color: #0056b3;
    transform: scale(1.05);
}

@media (max-width: 767px) {
    .floating-button-bar {
        bottom: 10px;
        padding: 5px 10px;
    }

    .floating-btn, .floating-support-btn {
        margin: 0 5px;
        font-size: 10px;
    }

    .floating-btn i, .floating-support-btn i {
        font-size: 20px;
    }
}

</style>
</body>

</html>
<?php /**PATH /home/stellar/public_html/core/resources/views/templates/basic/layouts/app.blade.php ENDPATH**/ ?>