
<?php $__env->startSection('content'); ?>
    <div class="card custom--card text--white mb-5">
        <div class="card-header py-3">
            <h5 class="card-title m-0"><?php echo app('translator')->get('Your Deposit Address'); ?></h5>
        </div>
        <div class="card-body py-3">
        <h4 class="card__dogecoin__balance text--white deposit-address d-none py-3"></h4>
<button class="cmn--btn copy-btn d-none" id="copyBtn" type="button" style="margin-top:10px;">
    <?php echo app('translator')->get('Copy Address'); ?>
</button>
<span class="copy-success-message text--success d-none"><?php echo app('translator')->get('Copied to clipboard!'); ?></span>

            

            <div class="d-none mb-2" id="waitingLoader">
                <i class="las la-spinner"></i>
            </div>
            <h4 class="d-none error-message text--danger mb-2"></h4>
            <form id="depositForm">
                <?php echo csrf_field(); ?>
                <button class="cmn--btn" id="submitBtn" type="submit"><?php echo app('translator')->get('GENERATE DEPOSIT ADDRESS'); ?></button>
            </form>
        </div>
        <div class="card-footer py-3">
            <span class="card__text">
                <?php echo app('translator')->get('Minimum Deposit Limit'); ?>: <?php echo e($gateway->minimum_deposit); ?> <?php echo e(__($general->cur_text)); ?>

                | <?php echo app('translator')->get('1 DH/S'); ?> = <?php echo e($general->dhs_price); ?> <?php echo e(__($general->cur_text)); ?>

                | <?php echo app('translator')->get('Daily'); ?> <strong><?php echo e($general->daily_earning); ?></strong> <?php echo e(__($general->cur_text)); ?> <?php echo app('translator')->get('Per DH/S'); ?> <br>   <?php echo app('translator')->get('Get 10% Daily'); ?>
            </span>
        </div>
    </div>
    <div class="active--miners">
        <h4 class="subtitle mb-4 pt-5 text-white"><?php echo app('translator')->get('Your Deposits'); ?></h4>
        <div class="table--responsive">
            <table class="cmn--table table--white">
                <thead>
                    <tr>
                        <th><?php echo app('translator')->get('TIME'); ?></th>
                        <th><?php echo app('translator')->get('WALLET'); ?></th>
                        <th><?php echo app('translator')->get('TRX NUMBER'); ?></th>
                        <th><?php echo app('translator')->get('AMOUNT'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                            <td class="text-center" colspan="100%"><?php echo app('translator')->get('NO DATA AVAILABLE'); ?></td>
                        </tr>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td class="text-center" colspan="100%"><?php echo app('translator')->get('NO DATA AVAILABLE'); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <?php if($deposits->hasPages()): ?>
                <?php echo e(paginateLinks($deposits)); ?>

            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            // Function to handle form submission and display deposit address
            $('#depositForm').on('submit', function(e) {
                e.preventDefault();
                $('#waitingLoader').removeClass('d-none').hide().show('slow');
                $('#submitBtn').attr('disabled', 'disabled');
                $('.error-message').addClass('d-none');
                var data = $(this).serialize();
                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('account.deposit')); ?>",
                    data: data,
                    dataType: "json",
                    success: function(data) {
                        if (data.error) {
                            $('#waitingLoader').addClass('d-none');
                            $('#submitBtn').removeAttr('disabled');
                            $('.error-message').removeClass('d-none').text(data.error);
                        } else {
                            $('#waitingLoader').addClass('d-none');
                            $('#depositForm').hide();
                            $('.deposit-address').text(data.address).removeClass('d-none');
                            $('#copyBtn').removeClass('d-none');
                            let qrcode = 'https://chart.googleapis.com/chart?chs=300x300&cht=qr&chl=' + data.address + '&choe=UTF-8';
                            $('#qrCodeImg').attr('src', qrcode);
                        }
                    }
                });
            });

            // Function to copy the deposit address to the clipboard
            $('#copyBtn').on('click', function() {
                var addressText = $('.deposit-address').text();
                var tempInput = document.createElement('input');
                tempInput.value = addressText;
                document.body.appendChild(tempInput);
                tempInput.select();
                document.execCommand('copy');
                document.body.removeChild(tempInput);

                // Show success message after copying
                $('.copy-success-message').removeClass('d-none').hide().fadeIn().delay(2000).fadeOut();
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stellar/public_html/core/resources/views/templates/basic/account/deposit.blade.php ENDPATH**/ ?>