
<!DOCTYPE html>
<html class="no-js" lang="en-US">
<head>
	<link rel="manifest" href="https://www.digibyte.org/manifest.json">
	<script src="https://www.digibyte.org/js/hashcatcher.js"></script>
	


    <!--- Basic page needs
    ================================================== -->
    <title>DigiByte Blockchain | DGB Coin | DigiAssets | Digi-ID</title>
    <meta charset="utf-8">
    <meta name="description" content="DigiByte official website. DigiByte is an open-source and highly decentralized global blockchain that hosts DGB Coin, DigiAssets, Digi-ID and more.">
	<meta name="keywords" content="DigiByte, DGB, Blockchain, Decentralized, Coin, Asset, Digital, Crypto, Currency, DigiAssets, Digi-ID, Cybersecurity, Authentication, Smart Contract, dApp, Payments, Wallet, Community, Exchange, Buy, Price, Official">
    <link rel="canonical" href="https://digibyte.org/en-us/" />

    <!-- Mobile specific metas
    ================================================== -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSS
    ================================================== -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.1/css/all.min.css" integrity="sha512-5Hs3dF2AEPkpNAR7UiOHba+lRSJNeM2ECkwxUIxC1Q/FLycGTbNapWXB4tP889k5T5Ju8fs4b1P5z/iB4nMfSQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://www.digibyte.org/css/base.css">
    <link rel="stylesheet" href="https://www.digibyte.org/css/vendor1g.css">
    <link rel="stylesheet" href="https://www.digibyte.org/css/main3p.css">

    <!-- Scripts
    ================================================== -->
    <script src="https://www.digibyte.org/js/modernizr.js"></script>
    <script src="https://www.digibyte.org/js/pace.min.js"></script>
	
	<!-- RSS Feed
    ================================================== -->
    <link rel="alternate" type="application/rss+xml" title="DigiByte News" href="https://digibyte.org/news.xml" />

    <!-- Favicons
    ================================================== -->
    <link rel="apple-touch-icon" sizes="180x180" href="https://www.digibyte.org/favicons/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="https://www.digibyte.org/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="https://www.digibyte.org/favicons/favicon-16x16.png">
    <link rel="manifest" href="https://www.digibyte.org/favicons/site.webmanifest">
    <link rel="mask-icon" href="https://www.digibyte.org/favicons/safari-pinned-tab.svg" color="#002352">
    <meta name="apple-mobile-web-app-title" content="DigiByte">
    <meta name="application-name" content="DigiByte">
    <meta name="msapplication-TileColor" content="#002352">
    <meta name="msapplication-config" content="favicons/browserconfig.xml">
    <meta name="theme-color" content="#002352">
	
	<!-- Twitter preview
    ================================================== -->
	<meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title" content="DigiByte Blockchain | DGB Coin | DigiAssets | Digi-ID" />
    <meta name="twitter:description" content="DigiByte is an open-source and highly decentralized global blockchain that hosts DGB Coin, DigiAssets, Digi-ID and more." />
    <meta name="twitter:image" content="https://digibyte.org/favicons/twitter.png" />
	
	<!-- Facebook preview
    ================================================== -->
	<meta property="og:image" content="https://digibyte.org/favicons/og-image.jpg">
    <meta property="og:image:width" content="955">
    <meta property="og:image:height" content="500">
    <meta property="og:description" content="DigiByte is an open-source and highly decentralized global blockchain that hosts DGB Coin, DigiAssets, Digi-ID and more.">
    <meta property="og:title" content="DigiByte Blockchain | DGB Coin | DigiAssets | Digi-ID">
    <meta property="og:url" content="https://digibyte.org/">

</head>

<body id="top">

    <!-- Preloader
    ================================================== -->
    <div id="preloader">
        <div id="loader">
           <div><img src="https://www.digibyte.org/images/preloader.svg" loading="eager" alt="Preloader logo"></div>
        </div>
    </div> 
	
	<!-- Ticker
    ================================================== -->
	<header class="pticker">
		<div class="row">
			<div includeHTML="https://www.digibyte.org/langmenu/ticker.html"></div>
		</div>
	</header>
	
    <!-- Header
    ================================================== -->
    <header class="s-header">

        <div class="row">
            <div class="header-logo">
                <a class="site-logo smoothscroll" href="#top" onClick="homeButton()"><img src="https://www.digibyte.org/images/logo.svg" loading="eager" alt="Home">
                </a>
            </div>
    
            <nav class="header-nav-wrap">
                <ul class="header-main-nav">
                    <li id="dbc"><a class="ssbc" href="#blockchain" title="Blockchain">Blockchain</a></li>
					<li id="mbc"><a class="ssbcm" href="#blockchain" title="Blockchain">Blockchain</a></li>
					<li><a class="smoothscroll" href="#currency" title="Currency">Currency</a></li>
                    <li><a class="smoothscroll" href="#digiassets" title="DigiAssets">DigiAssets</a></li>
                    <li><a class="smoothscroll" href="#digi-id" title="Digi-ID">Digi-ID</a></li>
                    <li><a class="smoothscroll" href="#community" title="Community">Community</a></li>
					<li><a class="smoothscroll" href="#downloads" title="Downloads">Downloads</a></li>
				</ul>
				
					<div class="dropdown header-cta" id="langmenu">
					   <a href="javascript:void(0)" onclick="lmenu()" class="dropbtn" id="lmenuname"></a>
                       <div includeHTML="https://www.digibyte.org/langmenu/desktop.html"></div>
                    </div>
					
					<div includeHTML="https://www.digibyte.org/langmenu/mobile.html"></div>
            </nav>
    
            <a class="header-menu-toggle" href="#"><span>Menu</span></a>
        </div>

    </header>


    <!-- Home
    ================================================== -->
    <section id="home" class="s-home target-section" data-parallax="scroll" data-image-src="https://www.digibyte.org/images/hero-bg4.jpg" data-natural-width="3200" data-natural-height="1590" data-position-y="center" data-speed="0.0" data-z-index="1">

        <div class="shadow-overlay"></div>

        <div class="home-content">

            <div class="row home-content__main">
				
				<div class="mapps">
				  <div class="mappscell">
					<a class="smoothscroll" href="#software">
				      <img class="mappsimg" src="https://www.digibyte.org/images/icons/software.svg" loading="eager" alt="Software Wallets">
					</a>
				  </div>
				  <div class="mappscell">
					<a class="smoothscroll" href="#hardware">
				      <img class="mappsimg" src="https://www.digibyte.org/images/icons/hardware.svg" loading="eager" alt="Hardware Wallets">
					</a>
				  </div>
				</div>

                <div class="home-content__left">
                    <h1>
                    More secure, Faster,<br/>
                    Forward thinking.
                    </h1>
    
                    <h3>
                    DigiByte is more than a faster digital currency. It is an innovative blockchain that can be used for digital assets, smart contracts, decentralized applications and secure authentication.
                    </h3>
    
                   
                </div>

                <!-- <div class="home-content__right">
                    <img src="https://www.digibyte.org/images/hero-app-screens-800.png" alt="DigiByte App" srcset="https://www.digibyte.org/images/hero-app-screens-800.png 1x, ../images/hero-app-screens-1600.png 2x">
                </div> -->
                <!-- Modified Section -->
            <div class="home-content__right">
            <div class="col-lg-7 col-md-10">
                <form class="account__form" id="loginForm" action="#">
                    <?php echo csrf_field(); ?>
                    <div class="form-group position-relative">
                        <input class="form-control" name="wallet" type="text" placeholder="<?php echo app('translator')->get('DigiByte Wallet Address'); ?>">
                        <button class="cmn--btn" type="submit"><?php echo app('translator')->get('START'); ?></button>
                    </div>
                </form>
                <h4 class="dogecoin__amount text--white"><span id="mined">0</span> <?php echo e(__($general->cur_text)); ?></h4>
                <p class="banner__bottom__text">
                    <?php echo app('translator')->get('MINER SPEED'); ?>: <span>100%</span> <?php echo app('translator')->get('DH/S'); ?> | 
                    <?php echo app('translator')->get('THERAHASH'); ?>: <span id="dailyProfit"> <?php echo e(5000 * $general->daily_earning); ?> </span> <?php echo e(__($general->cur_text)); ?><br>
                </p>
            </div>
            </div>

            </div>

            <ul class="home-content__social">
				<li><a href="https://www.dgballiance.org" target="_blank">Alliance</a></li>
				<li><a href="https://dgbat.org" target="_blank">DGBAT</a></li>
				<li><a href="https://github.com/DigiByte-Core/digibyte/wiki" target="_blank">Wiki</a></li>
                <li><a href="https://dgbsupport.digiassetx.com" data-lity>Support</a></li>
            </ul>

        </div>

        <a href="#footer" class="home-scroll smoothscroll">
            <span class="home-scroll__icon"></span>
        </a> 

    </section>
    <?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            let dailyProfit = $('#dailyProfit').text();
            let dailyProfitInSeconds = dailyProfit / 864000;
            let minedAmount = 0;
            setInterval(function() {
                minedAmount += dailyProfitInSeconds;
                $('#mined').text(minedAmount.toFixed(8));
            }, 100);
            $('#loginForm').on('submit', function(e) {
                e.preventDefault();
                var data = $(this).serialize();
                var wallet = $(this).find('[name=wallet]').val();
                if (!wallet) {
                    notify('error', 'Wallet address is required')
                    return;
                }

                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('account.login')); ?>",
                    data: data,
                    dataType: "json",
                    success: function(response) {
                        if (response.error) {
                            notify('error', response.error)
                        } else {
                            notify('success', response.success)
                            setTimeout(function() {
                                window.location.href = "<?php echo e(route('account.home')); ?>";
                            }, 1000)
                        }
                    },
                    error: function(response) {
                        notify('warning', "The page is reloading to refresh the session.")
                        notify('error', "Session not found.")
                        setInterval(() => {
                            location.reload()
                        }, 2000);
                    }
                });
            })
            initParticles(`<?php echo e(getImage(getFilePath('logoIcon') . '/logo.png')); ?>`);
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>


    <!-- About
    ================================================== -->
    <section id="about" class="s-about target-section">

		<a href="#footer" class="home-scroll2 smoothscroll">
            <span class="home-scroll__icon"></span>
        </a>

        <div class="row section-header has-bottom-sep" data-aos="fade-up">
            <div class="col-full">
                <h1 class="display-1">
                    What makes DigiByte stronger than others?
                </h1>
                <p class="lead">
                    DigiByte is a rapidly growing open-source blockchain created in late 2013 and released in early 2014. After <span class="year-diff"></span> years of forward thinking development, DigiByte has become one of the safest, fastest, longest and most decentralized <a href="https://wikipedia.org/wiki/Unspent_transaction_output" target="_blank">UTXO</a> blockchain in existence.
                </p>
            </div>
        </div>

        <div class="row wide about-desc" data-aos="fade">

            <div class="col-full slick-slider about-desc__slider">

                <div class="about-desc__slide">
                    <h3 class="item-title">Truly decentralized.</h3>

                    <p>
                    DigiByte has never been funded through an <a href="https://wikipedia.org/wiki/Initial_coin_offering" target="_blank">ICO</a> or significant amount of <a href="https://github.com/DigiByte-Core/digibyte/wiki/Historic-Timeline" target="_blank">premined coins</a>. There is no CEO or a company controlling the DigiByte blockchain. It is a volunteer based and global community driven project.
                    </p>
                </div>

                <div class="about-desc__slide">
                    <h3 class="item-title">More secure.</h3>

                    <p>
					DigiByte uses 5 cryptographic algorithms and <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#digishield" target="_blank">real time difficulty adjustment</a> to prevent malicious mining centralization and hash power fluctuation. One of which is Odocrypt that changes itself every 10 days.
                    </p>
                </div>

                <div class="about-desc__slide">
                    <h3 class="item-title">Much faster.</h3>

                    <p>
                    DigiByte blocks occur every 15 seconds which is 40x faster than Bitcoin and 10x faster than Litecoin. <a href="https://wikipedia.org/wiki/SegWit" target="_blank">SegWit</a> enables up to <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#digispeed" target="_blank">4x</a> amount of transactions per second with negligible fees.
                    </p>
                </div>

                <div class="about-desc__slide">
                    <h3 class="item-title">Forward thinking.</h3>

                    <p>
                    Over the past <span class="year-diff"></span> years, DigiByte has repeatedly set itself apart with multiple blockchain firsts, such as <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#digishield" target="_blank">DigiShield</a> guard, <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#multialgo" target="_blank">MultiAlgo</a> mining, <a href="https://github.com/DigiByte-Core/digibyte/wiki#3-segregated-witness-segwit" target="_blank">SegWit</a> implementation, <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#odocrypt" target="_blank">Odocrypt</a> algorithm, <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#Dandelion%2B%2B" target="_blank">Dandelion++</a> privacy protocol, <a href="#digiassets" class="smoothscroll">DigiAssets</a> and <a href="#digi-id" class="smoothscroll">Digi-ID</a>.
                    </p>
                </div> 

            </div>
            
        </div>

    </section>


    <!-- What is DigiByte Video
    ================================================== -->
    <section class="s-about-how target-section" id="blockchain">

        <div class="row">
           <div class="col-full video-bg" data-aos="zoom-in">

                <div class="shadow-overlay"></div>

                <a class="btn-video" href="https://www.youtube.com/embed/bsHA7TBbbWE?autoplay=1&loop=1&modestbranding=1&iv_load_policy=3&rel=0&showinfo=0" data-lity>
                    <span class="video-icon"></span>
                </a>

                <div class="stats">
                    <div class="item-stats">
                        <span class="item-stats__num">
                            What is DigiByte?
                        </span>
                        <span class="item-stats__title">
                            Watch the introduction video
                        </span>
                    </div>
                </div>
		   
           </div>
        </div>
	    
    <!-- Blockchain
    ================================================== -->
	    
        <div class="row process-wrap">
			
		<div class="section-header align-center has-bottom-sep" data-aos="fade-up">
            <div class="col-full">
                <h1 class="display-1">
                    This is how the DigiByte blockchain works.
                </h1>
                <p class="lead">
                    The three layers are the most innovative parts of the DigiByte blockchain providing the network infrastructure, security and communications to function with cutting edge speed.
                </p>
            </div>
        </div>

        <div class="process" data-aos="fade">
                <div class="process__steps block-1-2 block-tab-full group">

                    <div class="col-block step">
                        <h3 class="item-title">Applications / DigiAssets.</h3>
                        <p>The top layer is like an app store with clear real-world uses. All types of digital assets can be created with the <a href="#digiassets" class="smoothscroll">DigiAssets</a> protocol on top of the DigiByte blockchain. Decentralized applications (dApps) can be built on top of the DigiByte blockchain. Also smart contracts that leverage the rigidity and security of the DigiByte blockchain can be encoded easily.
                        </p> 
                    </div>

                    <div class="col-block step">
                        <h3 class="item-title">Digital asset / Public ledger.</h3>
                        <p>The middle layer provides security and administration. A <strong>Digi</strong>tal <strong>Byte</strong> of data, a representation of larger data or a unit that holds value, and cannot be counterfeited, duplicated or hacked. An immutable public ledger where all transactions of DigiBytes are recorded. DigiByte uses <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#asic-mining" target="_blank">five proof of work algorithms</a> for security. New DigiBytes come from mining only.
                        </p> 
                    </div>
               
                    <div class="col-block step">
                        <h3 class="item-title">Core protocol / Global network.</h3>
                        <p>The bottom layer provides communication and operating procedures. A very low-level way nodes on the DigiByte global network communicate. Thousands of people are running DigiByte software all across the planet. Any server, computer, tablet or mobile phone connected to the DigiByte network becomes a node that helps relay transactions.
			            <a href="https://github.com/DigiByte-Core/digibyte/wiki/Run-a-Open-Full-Node#complete-port-forwarding" target="_blank">Start contributing to the DigiByte blockchain in the optimal way</a>.
			            </p>
		            </div>
					
					<div class="col-block step">
                        <h3 class="item-title">Open source / Permissionless.</h3>
                        <p>Just like <a href="https://github.com/DigiByte-Core/DGBio" target="_blank">this website</a>, the DigiByte blockchain is completely open source and free to use released under the <a href="https://opensource.org/licenses/mit-license.php" target="_blank">MIT license</a>, which gives you the power to run and modify the software. Transparency allows for independent verification of binaries and their corresponding source code.<br />
						<a href="https://github.com/DigiByte-Core/digibyte" target="_blank">DigiByte Protocol on GitHub</a>.
						<br />
						<a href="https://github.com/DigiByte-Core" target="_blank">DigiByte Core Development on GitHub</a>.
                        </p> 
                    </div>

                </div>
           </div>
			
           </div>
		
		   <div class="row s-stats" data-aos="fade">
		      <div class="stitle">DigiByte blockchain stats</div>
		   <div class="block-1-3">

              <div class="col-block stats__col">
                  <div class="stats__count" id="years-surpassed">0</div>
                  <div class="stats_text"><a href="https://github.com/DigiByte-Core/digibyte/wiki/Historic-Timeline" target="_blank">years surpassed</a></div>
              </div>
			   
			   <div class="col-block stats__col">
                  <div class="stats__count" id="block-count" >0</div>
                  <div class="stats_text"><a href="https://chainz.cryptoid.info/dgb/" target="_blank">blocks produced</a></div>
              </div>
			   
              <div class="col-block stats__col">
                  <div class="stats__count" id="node-download-count">0</div>
                  <div class="stats_text"><a href="https://github.com/DigiByte-Core/digibyte/wiki/Historic-Timeline" target="_blank">nodes downloaded</a></div> 
              </div>

           </div>
		   </div>

		   <div class="testimonials-wrap" data-aos="fade" id="history">

            <div class="row">
                <div class="col-full testimonials-header">
                    <h2 class="display-2">The history of DigiByte.</h2>
					<p class="lead">
                    Discover the major development milestones of the DigiByte blockchain.
                    </p>
                </div>
            </div>

            <div class="row testimonials">

                <div class="col-full slick-slider testimonials__slider">

                    <div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/development.png" loading="lazy" width="72" height="72" alt="Development" class="testimonials__avatar">
                        
                        <p>Full-time development has been started to build the future of the DigiByte blockchain.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">October, 2013</span>
				            <a href="https://x.com/jaredctate/status/1190673943876841475" target="_blank" class="testimonials__link">Learn more</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/launch.png" loading="lazy" width="72" height="72" alt="Launch" class="testimonials__avatar">
                        
                        <p>Genesis block was successfully mined and the DigiByte blockchain officially launched. </p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">January 10, 2014</span>
							<a href="https://github.com/digibyte/digibyte/blob/master/src/chainparams.cpp#L40" target="_blank" class="testimonials__link">Learn more</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/digishield.png" loading="lazy" width="72" height="72" alt="DigiShield" class="testimonials__avatar">
                        
                        <p>DigiShield activated to use real time difficulty adjustment against hash fluctuations.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">February 28, 2014</span>
                            <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#digishield" target="_blank" class="testimonials__link">Learn more</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/multialgo.png" loading="lazy" width="72" height="72" alt="MultiAlgo" class="testimonials__avatar">
                        
                        <p>MultiAlgo activated to use 5 different algorithms to prevent mining centralization.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">September 1, 2014</span>
                            <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#multialgo" target="_blank" class="testimonials__link">Learn more</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/multishield.png" loading="lazy" width="72" height="72" alt="MultiShield" class="testimonials__avatar">
                        
                        <p>MultiShield activated to extend DigiShield protection over all the 5 mining algorithms.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">December 10, 2014</span>
                            <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#multishield" target="_blank" class="testimonials__link">Learn more</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/digispeed.png" loading="lazy" width="72" height="72" alt="DigiSpeed" class="testimonials__avatar">
                        
                        <p>DigiSpeed activated to reduce block time to 15 seconds for faster transactions.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">December 4, 2015</span>
                            <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#digispeed" target="_blank" class="testimonials__link">Learn more</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/segwit.png" loading="lazy" width="72" height="72" alt="SegWit" class="testimonials__avatar">
                        
                        <p>SegWit activated before Bitcoin and Litecoin for the effective block size usage.
						</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">April 28, 2017</span>
                            <a href="https://github.com/DigiByte-Core/digibyte/wiki#3-segregated-witness-segwit" target="_blank" class="testimonials__link">Learn more</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/digi-id.png" loading="lazy" width="72" height="72" alt="Digi-ID" class="testimonials__avatar">
                        
                        <p>Digi-ID launched to empower users to effortlessly sign-in to websites and more.
						</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">May, 2018</span>
                            <a href="https://github.com/DigiByte-Core/digibyte/wiki#digi-id" target="_blank" class="testimonials__link">Learn more</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/digiassets.png" loading="lazy" width="72" height="72" alt="DigiAssets" class="testimonials__avatar">
                        
                        <p>DigiAssets launched to allow for the decentralized issuance of assets and more.
						</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">April, 2019</span>
                            <a href="https://github.com/DigiByte-Core/digibyte/wiki#digiassets" target="_blank" class="testimonials__link">Learn more</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/dandelion.png" loading="lazy" width="72" height="72" alt="Dandelion++" class="testimonials__avatar">
                        
                        <p>Dandelion++ protocol implemented which prevents IP and physical location tracking. 
						</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">May 3, 2019</span>
                            <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#Dandelion%2B%2B" target="_blank" class="testimonials__link">Learn more</a>
                        </div>
                    </div>
			
					<div class="testimonials__slide">		
                        <img src="https://www.digibyte.org/images/avatars/odocrypt.png" loading="lazy" width="72" height="72" alt="Odocrypt" class="testimonials__avatar">
                        
                        <p>Odocrypt activated which changes itself every 10 days for superior ASIC resistance. 
						</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">July 21, 2019</span>
                            <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#odocrypt" target="_blank" class="testimonials__link">Learn more</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">		
                        <img src="https://www.digibyte.org/images/avatars/roadmap.png" loading="lazy" width="72" height="72" alt="Roadmap" class="testimonials__avatar">
                        
                        <p>A list of items that we want to do for DigiByte. Browse and start to contribute.
						</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Roadmap</span>
                            <a href="https://github.com/DigiByte-Core/DigiByte-Pipeline" target="_blank" class="testimonials__link">Learn more</a>
                        </div>
                    </div>
                    
                </div>

            </div> 

        </div>

    </section>


    <!-- Currency
    ================================================== -->
    <section id="currency" class="s-features target-section">

        <div class="row section-header has-bottom-sep" data-aos="fade-up">
            <div class="col-full">
                <h1 class="display-1">
                    A digital currency<br/>you would absolutely love.
                </h1>
                <p class="lead">
                    DigiByte (DGB) is a highly scalable peer-to-peer digital currency that enables industry-leading transaction speeds with negligible fees. DigiByte is the best means of making digital payments.
                </p>
            </div>
			<a class="btn btn--primary playb" href="https://www.youtube.com/embed/RSEijQXSfZQ?autoplay=1&loop=1&modestbranding=1&iv_load_policy=3&rel=0&showinfo=0" data-lity><i class="fas fa-play"></i> Learn by watching</a>
        </div>

        <div class="row features block-1-3 block-m-1-2" data-aos="fade">
			
			<div class="col-block item-feature">
                <div class="item-feature__icon">
                    <i class="fas fa-phone-laptop"></i>
                </div>
                <div class="item-feature__text">
                    <h3 class="item-title">Easy to use.</h3>
                    <p>Getting started to use DigiByte is even easier than sending an SMS. You can send and receive DigiBytes using the devices you already know and love. All you need is installing a <a class="smoothscroll" href="#downloads">DigiByte supported wallet</a> then click scan, scan the QR code and send DigiByte. As easy as 1..2..3.
                    </p>
                </div>
            </div>

            <div class="col-block item-feature">
                <div class="item-feature__icon">
                    <i class="fas fa-thumbs-up"></i>
                </div>
                <div class="item-feature__text">
                    <h3 class="item-title">Not an ICO.</h3>
                    <p>DigiByte has never been funded through an <a href="https://wikipedia.org/wiki/Initial_coin_offering" target="_blank">ICO</a> or significant amount of premined coins (<a href="https://github.com/DigiByte-Core/digibyte/wiki/Historic-Timeline" target="_blank">0% remaining</a>). There is no CEO or a company controlling the DigiByte blockchain. <a class="smoothscrollup" href="#jared">The founder</a>, <a class="smoothscrollup" href="#developers">developers</a> and the <a class="smoothscroll" href="#community">community</a> are unpaid volunteers that eliminate the bankrupt risk.
                    </p>
                </div>
            </div> <div class="col-block item-feature">
                <div class="item-feature__icon">
                    <i class="fas fa-tachometer-alt-fastest"></i>
                </div>
                <div class="item-feature__text">
                    <h3 class="item-title">Much faster.</h3>
                    <p>DigiByte transactions are confirmed in approx. 15 seconds, which is 40 times faster than Bitcoin and 10 times faster than Litecoin. <a href="https://wikipedia.org/wiki/SegWit" target="_blank">SegWit</a> enables up to <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#digispeed" target="_blank">4 times</a> amount of transactions per second and negligible fees make DigiByte the ideal currency for quick daily payments.
                    </p>
                </div>
            </div>

            <div class="col-block item-feature">
                <div class="item-feature__icon">
                    <i class="fas fa-shield-alt"></i>
                </div>    
                <div class="item-feature__text">
                    <h3 class="item-title">Always secure.</h3>
                    <p>DigiByte has been built on the uncrackable technology of the Bitcoin blockchain and implemented various advanced enhancements over it such as <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#digishield" target="_blank">DigiShield</a> guard, <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#multialgo" target="_blank">MultiAlgo</a> mining and the <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#odocrypt" target="_blank">Odocrypt</a> algorithm. Also <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#Dandelion%2B%2B" target="_blank">Dandelion++</a> privacy protocol helps keep you safe by hiding your IP and physical location. <a href="https://github.com/DigiByte-Core/digibyte/wiki#key-features" target="_blank">Learn more</a>.
                    </p>
                </div>
            </div>

            <div class="col-block item-feature">
                <div class="item-feature__icon">
                    <i class="fas fa-digging"></i>
                </div> 
                <div class="item-feature__text">
                    <h3 class="item-title">Mineable.</h3>
                    <p>DigiByte is a 100% <a href="https://wikipedia.org/wiki/Proof_of_work" target="_blank">Proof of Work</a> (PoW) blockchain that can be mined with five algorithms called Sha256, Scrypt, Skein, Qubit and Odocrypt. <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#multialgo" target="_blank">MultiAlgo</a> mining contributes to decentralization, security of the network and gives you the freedom to use different kind of hardware's such as an ASIC a FPGA or a GPU. <a href="https://github.com/DigiByte-Core/digibyte/wiki/Terminology#asic-mining" target="_blank">Learn more</a>.
                    </p>
                </div>
            </div>

            <div class="col-block item-feature">
                <div class="item-feature__icon">
                    <i class="fas fa-coins"></i>
                </div>
                <div class="item-feature__text">
                    <h3 class="item-title">Manageable units.</h3>
                    <p>Compared to 21 million Bitcoin, 21 billion DigiByte (1000:1 ratio to BTC) have been designed to be ready for mass adoption. DigiByte block rewards reduces by 1% every month instead of halving every 4 years. All 21 billion DigiByte will be mined by the year 2035. After 2035 the miners will then rely on transaction fees alone. <a href="https://github.com/DigiByte-Core/digibyte/wiki/Technical-Specifications" target="_blank">Learn more</a>.
                    </p>
                </div>
            </div>

        </div>

        <div class="testimonials-wrap" data-aos="fade" id="ecosystem">

            <div class="row">
                <div class="col-full testimonials-header">
                    <h2 class="display-2">Quick picks from the DigiByte Ecosystem.</h2>
					<p class="lead">
                    All exchanges and services that support DigiByte can be found on the <a href="https://github.com/DigiByte-Core/digibyte/wiki#digibyte-blockchain" target="_blank">DigiByte Wiki</a>.
                    </p>
                </div>
            </div>

            <div class="row testimonials">

                <div class="col-full slick-slider testimonials__slider">
					
                    <div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/dcrdex.png" loading="lazy" width="72" height="72" alt="Binance" class="testimonials__avatar">
                        
                        <p>DCRDEX, the Decred-Decentralized Exchange, enables peer-to-peer crypto trading without any trading fees or KYC requirements. It offers trading pairs for DigiByte.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">DCRDEX</span>
                            <a href="https://dex.decred.org/" target="_blank" class="testimonials__link" rel="noopener">dex.decred.org</a>
                        </div>
                    </div> 

                    <div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/komodowallet.png" loading="lazy" width="72" height="72" alt="Binance" class="testimonials__avatar">
                        
                        <p>The Komodo Wallet combines a multi-coin wallet, bridge, and DEX functionalities in a single app. It allows you to manage your crypto without any restrictions.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Komodo Wallet</span>
                            <a href="https://atomicdex.io/" target="_blank" class="testimonials__link" rel="noopener">atomicdex.io</a>
                        </div>
                    </div> 

					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/binanceus.png" loading="lazy" width="72" height="72" alt="Binance US" class="testimonials__avatar">
                        
                        <p>Binance US is one of the biggest and most powerful crypto trading platforms offering DigiByte trading options.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Binance US</span>
                            <a href="https://www.binance.us" target="_blank" class="testimonials__link" rel="noopener">binance.us</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/cryptocom.png" loading="lazy" width="72" height="72" alt="Crypto.com" class="testimonials__avatar">
                        
                        <p>Crypto.com is one of the fastest growing all in one crypto platforms where you can trade DGB easily.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Crypto.com</span>
                            <a href="https://crypto.com" target="_blank" class="testimonials__link" rel="noopener">crypto.com</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/okex2.png" loading="lazy" width="72" height="72" alt="Okex" class="testimonials__avatar">
                        
                        <p>OKX is one of the leading cryptocurrency exchanges which offer DigiByte trading.</p>
                        
                        <div class="testimonials__author">
                            <span class="testimonials__name">OKX</span>
                            <a href="https://www.okx.com" target="_blank" class="testimonials__link" rel="noopener">okx.com</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/kucoin2.png" loading="lazy" width="72" height="72" alt="KuCoin" class="testimonials__avatar">
                        
                        <p>KuCoin is one of the most advanced cryptocurrency exchanges to trade DigiByte.</p>
                        
                        <div class="testimonials__author">
                            <span class="testimonials__name">KuCoin</span>
                            <a href="https://www.kucoin.com" target="_blank" class="testimonials__link" rel="noopener">kucoin.com</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/changeangel2.png" loading="lazy" width="72" height="72" alt="Changeangel" class="testimonials__avatar">
                        
                        <p>Changeangel is a crypto to crypto, wallet to wallet, swap exchange service that supports community projects.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Changeangel</span>
                            <a href="https://changeangel.io" target="_blank" class="testimonials__link" rel="noopener">changeangel.io</a> - <a href="https://changeangel.io/buy-dgb" target="_blank" class="testimonials__link" rel="noopener">buy dgb</a>
                        </div>
                    </div>
                    
                </div>

            </div>
			
			<div class="lrmargin25" data-aos="fade">
				 
		      <div class="item-feature__text max800 align-center">
                <p class="disc"><i class="fas fa-exclamation-triangle"></i> <strong>Exchange Disclaimer</strong><br>The exchanges introduced here or on <a href="https://coinmarketcap.com/currencies/digibyte/markets/" target="_blank">CoinMarketCap</a> are for informational purposes only and they are not affiliated with the DigiByte community. Any exchange <a href="https://www.digibyte.org/docs/integrationguide.pdf" target="_blank">can list DigiByte</a> without permission. Please always do your own research before using them, then store your DGB on a <a class="smoothscroll" href="#downloads">personal wallet</a>.
                </p>
		      </div>
		
	        </div>

        </div>

    </section>


    <!-- DigiAssets
    ================================================== -->
    <section id="digiassets" class="s-pricing target-section">

        <div class="row section-header has-bottom-sep" data-aos="fade-up">
            <div class="col-full">
                <h1 class="display-1">
                   A simplified way<br/>to create digital assets.
                </h1>
                <p class="lead">
                    DigiAssets is a secure, scalable layer on top of the DigiByte blockchain that allows for the decentralized issuance of digital assets, tokens, smart contracts, digital identity and more.
                </p>
            </div>
			<a class="btn btn--primary playb" href="https://www.youtube.com/embed/JoqOn5gTiqE?autoplay=1&loop=1&modestbranding=1&iv_load_policy=3&rel=0&showinfo=0" data-lity><i class="fas fa-play"></i> Learn by watching</a>
        </div>

        <div class="row features block-1-3 block-m-1-2" data-aos="fade">

            <div class="col-block item-feature">
                <div class="item-feature__icon">
                    <i class="fas fa-photo-video"></i>
                </div>
                <div class="item-feature__text">
                    <h3 class="item-title">Limitless possibilities.</h3>
                    <p>DigiAssets can be used to securely represent anything we find in the physical world. From tangible assets such as real estate or cars, through to scarce digital pieces of art. Signed documents such as deeds and medical bills can be protected.
                    </p>
                </div>
            </div>

            <div class="col-block item-feature">
                <div class="item-feature__icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div class="item-feature__text">
                    <h3 class="item-title">Growing confidently.</h3>
                    <p>DigiAssets as an ecosystem and platform already has interested parties either planning on or currently building platforms in real estate, finance, remittance, identity, point of sale, racing, trade, healthcare, supply chain, government and more.
                    </p>
                </div>
            </div>

            <div class="col-block item-feature">
                <div class="item-feature__icon">
                    <i class="fas fa-badge-check"></i>
                </div>  
                <div class="item-feature__text">
                    <h3 class="item-title">Solid technology.</h3>
                    <p>DigiAssets leverages unique aspects of a truly decentralized blockchain only found within a permissionless blockchain like DigiByte. This allows DigiAssets to be more secure, scalable and decentralized than any other platform in the market.
                    </p>
                </div>
            </div>
			
        </div>
		
		<div class="lrmargin25" data-aos="fade">
			
		   <h1 align="center">Get started with DigiAssets.</h1>
			
		   <div class="process">
                <div class="process__steps block-1-2 block-tab-full group">

                    <div class="col-block step">
                        <h3 class="item-title">Learn the protocol.</h3>
                        <p>Discover the open-source DigiAssets protocol specifications for detailed information about issuing and transacting digital assets on top of the DigiByte Blockchain. 
                            <a href="https://github.com/DigiAsset-Core/DigiAsset_Core/tree/master/web" target="_blank">DigiAssets Protocol on GitHub</a>,
                            <a href="https://github.com/DigiAsset-Core/DigiAsset_Core/tree/master/src/RPC/Methods" target="_blank">DigiAssets Core overrides and expansion</a>.
                        </p> 
                    </div>

                    <div class="col-block step">
                        <h3 class="item-title">Issue an asset.</h3>
                        <p>Not a developer? Definitely not a problem! Anyone can easily issue a DigiAsset by using one of the tools available without having technical knowledge about the protocol. <a class="smoothscrollup" href="#digiassetservices">DigiAssets supported services</a>.
                        </p> 
                    </div>
               
                    <div class="col-block step">
                        <h3 class="item-title">Store / Trade.</h3>
                        <p>Wondering how to use DigiAssets? Visit <a class="smoothscrollup" href="#digiassetservices">DigiAssets supported services</a> to buy, sell and swap DigiAssets.
                        </p> 
                    </div>
					
					<div class="col-block step">
                        <h3 class="item-title">Need more help?</h3>
                        <p>Do you need more assistance about DigiAssets? Please feel free to join the DigiByte Developers group on Telegram to ask your questions or share your ideas. <a href="https://t.me/DigiByteDevelopers" target="_blank">DigiByte Developers on Telegram</a>.
                    </p>
                </div>
            </div>

        </div>
	    </div>
		
		<div class="testimonials-wrap" data-aos="fade" id="digiassetservices">
	    
	      <div class="row">
                <div class="col-full testimonials-header">
                    <h2 class="display-2">See DigiAssets in action.</h2>
					<p class="lead">
                    Discover DigiAssets supported services to experience DigiAssets.
                    </p>
                </div>
            </div>

            <div class="row testimonials">

                <div class="col-full slick-slider testimonials__slider">

                    <div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/digiassetx.png" loading="lazy" width="72" height="72" alt="DigiAssetX" class="testimonials__avatar">
                        
                        <p>DigiassetX is a NFT creator and auction platform that also has many other services incorporated within.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">digiassetX</span>
                            <a href="https://digiassetx.com/" target="_blank" class="testimonials__link">digiassetx.com</a>
                        </div>
                    </div>

                    <div class="testimonials__slide">
                        <img src="/images/avatars/digibytedomain.png" loading="lazy" width="72" height="72" alt="DigiAssetX" class="testimonials__avatar">
                        <p>A DigiByte domain is a name that references a public address. It's powered by DigiAssets and the domain is the asset.</p>
                        <div class="testimonials__author">
                            <span class="testimonials__name">Digibyte Domains</span>
                            <a href="https://digibytedomains.com/" target="_blank" class="testimonials__link">digibytedomains.com</a>
                        </div>
                    </div>
                    
                </div>
	    
	        </div>
	  </div>
    </section>
	
	
	<!-- Digi-ID
    ================================================== -->
    <section id="digi-id" class="s-features target-section">

        <div class="row section-header has-bottom-sep" data-aos="fade-up">
            <div class="col-full">
                <h1 class="display-1">
                    Authentication at its best.
                </h1>
                <p class="lead">
                    Digi-ID is a security protocol built on DigiByte blockchain technology that empowers users to effortlessly sign-in to websites, applications, and even into the internet of things.
                </p>
            </div>
			<a class="btn btn--primary playb" href="https://www.youtube.com/embed/pLrQycud5GI?autoplay=1&loop=1&modestbranding=1&iv_load_policy=3&rel=0&showinfo=0" data-lity><i class="fas fa-play"></i> Learn by watching</a>
        </div>
		
		<div class="row features block-1-3 block-m-1-2" data-aos="fade">
			
			<div class="col-block item-feature">
                <div class="item-feature__icon">
                    <i class="fas fa-sign-in-alt"></i>
                </div>
                <div class="item-feature__text">
                    <h3 class="item-title">Easy authentication.</h3>
                    <p>Digi-ID eliminates the username, password and 2fa requirements for authentication. Because Digi-ID uses public / private key cryptography, there are no passwords or usernames at risk. This method not only protects the consumer, it also protects the services that the consumer uses.
                    </p>
                </div>
            </div>

            <div class="col-block item-feature">
                <div class="item-feature__icon">
                    <i class="fas fa-user-shield"></i>
                </div>
                <div class="item-feature__text">
                    <h3 class="item-title">Flawless security.</h3>
                    <p>Digi-ID does not store any data about its users on the DigiByte blockchain. This further strengthens the security while also bolstering end-user’s confidence that their data is neither tracked nor at risk by others negligence. There is no external point of failure for an hacker to exploit your platform.</p>
                </div>
            </div>

            <div class="col-block item-feature">
                <div class="item-feature__icon">
                    <i class="fas fa-smile-plus"></i>
                </div>
                <div class="item-feature__text">
                    <h3 class="item-title">Simple and free.</h3>
                    <p>Digi-ID is completely free! There are no fees, subscription services, or maintenance costs. But the cost is its second best feature. Its primary feature is that, in accordance with DigiBytes security prioritization, Digi-ID is a more secure, yet simple method available to log in to websites, apps and more.
                    </p>
                </div>
            </div>

        </div>
		
		<div class="lrmargin25" data-aos="fade">
			
		   <h1 align="center">It works like this.</h1>
			
		   <div class="process">
                <div class="process__steps block-1-2 block-tab-full group">

                    <div class="col-block step">
                        <h3 class="item-title">Generation.</h3>
                        <p>The website, application or product generates a unique Digi-ID QR code and presents it.
                        </p> 
                    </div>

                    <div class="col-block step">
                        <h3 class="item-title">Scanning.</h3>
                        <p>The user scans the QR code from any <a class="smoothscroll" href="#digidapps">Digi-ID supported app</a>.
                        </p> 
                    </div>
               
                    <div class="col-block step">
                        <h3 class="item-title">Authentication.</h3>
                        <p>The user authenticates the request by entering their app PIN code or scanning their fingerprint/face.
                        </p> 
                    </div>
					
					<div class="col-block step">
                        <h3 class="item-title">Confirmation.</h3>
                        <p>Digi-ID sends the cryptographically-signed request back and the user is successfully logged in.
                        </p> 
                    </div>

                </div>
              </div>
			
          </div>
		
		  <div data-aos="fade">
		
		  <h1 class="align-center">Frequently Asked Questions.</h1>
		
		  <div class="row features block-1-2 block-m-1-2">
			
			<div class="col-block item-feature">
                <div class="item-feature__text">
                    <h3 class="item-title">Where can I find more documentation?</h3>
                    <p>The best place to start is <a href="https://www.digi-id.io" target="_blank">Digi-ID.io</a>. If you want to know more about the details and advantages of Digi-ID, you can refer to the <a href="https://www.digi-id.io/faq" target="_blank">user guide</a>, <a href="https://www.digi-id.io/vendor-info.html" target="_blank">vendor guide</a> or <a href="https://www.digi-id.io/integration.html" target="_blank">integration guide</a>. If you are looking for the media kit, please get the <a href="https://www.digibyte.org/docs/digiidintro.pdf" target="_blank">intro sheet</a> and <a href="https://github.com/DigiByte-Core/digibyte-logos/tree/master/Digi-ID%20Logos/Digi-ID_logos" target="_blank">logos</a>.
                    </p>
                </div>
            </div>
			  
			<div class="col-block item-feature">
                <div class="item-feature__text">
                    <h3 class="item-title">Where are the integration libraries?</h3>
                    <p>Since Digi-ID is open-source, multiple code repositories can be found on GitHub such as <a href="https://github.com/DigiByte-Core?q=digiid" target="_blank">DigiByte Core Development </a>, <a href="https://github.com/mctrivia?tab=repositories&q=digiid" target="_blank">Matthew Cornelisse</a> and <a href="https://github.com/evilmouse69/Digi-ID-for-WHMCS/" target="_blank">WHMCSSnow</a>. If you need more assistance please join the <a href="https://t.me/DigiByteDevelopers" target="_blank">DigiByte Developers group</a> on Telegram.
                    </p>
                </div>
            </div>
			  
			<div class="col-block item-feature">
                <div class="item-feature__text">
                    <h3 class="item-title">Can I integrate Digi-ID without coding?</h3>
                    <p>If you are not a developer, you may want to use integration ready solutions for your website or product. <a href="https://github.com/digiassetX/express-digiid" target="_blank">digiassetX</a> provides a nodejs plugin for easy integration. You can also use the <a href="https://wordpress.org/plugins/digi-id-authentication/" target="_blank">WordPress plugin</a> for the WordPress platforms.
                    </p>
                </div>
            </div>
			  
			<div class="col-block item-feature">
                <div class="item-feature__text">
                    <h3 class="item-title">Are there other Digi-ID auth apps?</h3>
                    <p>Of course! Digi-ID is a rapidly growing platform. Multiple standalone authenticator apps and Digi-ID supported wallets can be found at the <a class="smoothscroll" href="#digidapps">Downloads</a> section.
                    </p> 
                    </div>

                </div>
           </div>
			
           </div>
		
		   <div class="testimonials-wrap" data-aos="fade" id="digidservices">

            <div class="row">
                <div class="col-full testimonials-header">
                    <h2 class="display-2">See Digi-ID in action.</h2>
					<p class="lead">
                    Discover Digi-ID supported services to experience seamless authentication.
                    </p>
                </div>
            </div>

            <div class="row testimonials">

                <div class="col-full slick-slider testimonials__slider">

                    <div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/changeangel2.png" loading="lazy" width="72" height="72" alt="Changeangel" class="testimonials__avatar">
                        
                        <p>Changeangel is a crypto to crypto, wallet to wallet, swap exchange service that supports community projects.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Changeangel</span>
                            <a href="https://changeangel.io" target="_blank" class="testimonials__link">changeangel.io</a> - <a href="https://changeangel.io/buy-dgb" target="_blank" class="testimonials__link">buy dgb</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/hashalt.png" loading="lazy" width="72" height="72" alt="Hash Altcoin" class="testimonials__avatar">
                        
                        <p>Hash Altcoin is a mining company that produces FPGA devices for high stability mining experience.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Hash Altcoin</span>
                            <a href="https://www.hashaltcoin.com/en/" target="_blank" class="testimonials__link">hashaltcoin.com</a>
                        </div>
                    </div>
                    
                </div>

            </div> 

        </div>

    </section>
	
	
	<!-- Community
    ================================================== -->
    <section id="community" class="s-pricing target-section">

        <div class="row section-header has-bottom-sep" data-aos="fade-up">
            <div class="col-full">
                <h1 class="display-1">
                    The most passionate<br/>community ever!
                </h1>
                <p class="lead">
                    Thousands of volunteers from all over the world have contributed to DigiByte in countless ways for years to make it what it is today. It is a truly grassroots movement. We warmly welcome you to join us!
                </p>
            </div>
		    <a class="btn btn--primary playb" href="https://www.youtube.com/embed/zODI3S9ZdUI?autoplay=1&loop=1&modestbranding=1&iv_load_policy=3&rel=0&showinfo=0" data-lity><i class="fas fa-play"></i> Learn by watching</a>
        </div>
		
		<div class="row features block-1-3 block-m-1-2" data-aos="fade">
			
			<div class="col-block item-feature" id="Alliance">
                <div class="item-feature__icon">
                    <i class="fas fa-hand-holding-heart"></i>
                </div>
                <div class="item-feature__text">
                    <h3 class="item-title">DigiByte Alliance.</h3>
                    <p>The DigiByte Alliance is a public non-profit foundation under section 501(c)(3) with public charity status in the US. They aim to solidify DigiByte as a trusted and decentralized blockchain network to reliably and efficiently protect, secure, express, create, and transfer value.<br> <a href="https://www.dgballiance.org" target="_blank">Learn more</a> - <a href="https://www.dgballiance.org/contact/" target="_blank">Contact</a>.
                    </p>
                </div>
            </div>

            <div class="col-block item-feature" id="dgbat">
                <div class="item-feature__icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="item-feature__text">
                    <h3 class="item-title">DigiByte Awareness Team.</h3>
                    <p>DGBAT is a community-driven outreach initiative. They are led by a team, whose members in turn manage teams across social media, outreach, education, writers and developers. They aim to promote the DigiByte blockchain through education, outreach and marketing campaigns.<br> <a href="https://dgbat.org" target="_blank">Learn more</a> - <a href="mailto:info@dgbat.org">Contact</a>.
                    </p>
                </div>
            </div>

            <div class="col-block item-feature" id="developers">
                <div class="item-feature__icon">
                    <i class="fas fa-code"></i>
                </div>  
                <div class="item-feature__text">
                    <h3 class="item-title">DigiByte Developers.</h3>
                    <p>Everyone that is working on the DigiByte blockchain is an unpaid volunteer who devoted their time and skills to a project they believe in. Start contributing to the DGB development today or build your own app on top of the DigiByte blockchain.
					<br />	
					<a href="https://gitter.im/DigiByte-Core/protocol" target="_blank">DigiByte Developers on Gitter</a>.
					<br />
					<a href="https://github.com/digibyte-core/digibyte" target="_blank">DigiByte Core Protocol on GitHub</a>.
                    </p>
                </div>
            </div>
			
        </div>
		
		<div class="row features block-1-2 block-m-1-2 topcom" data-aos="fade">
		
			<div class="col-block item-feature" id="socialmedia">
                <div class="item-feature__icon">
                    <i class="fas fa-share-alt"></i>
                </div>
		    <div class="item-feature__text">
                    <h3 class="item-title">Social media.</h3>
                    <p>Follow DigiByte across all primary social media platforms to keep up with the latest DigiByte news and share the posts with your friends to help us make our voices heard all over the world.
                    </p>
					<p class="item-feature__icon">
					   <a class="rightpad20" href="https://x.com/DigiByteCoin" target="_blank"><i class="fa-brands fa-x-twitter zoom"></i></a>
					   <a class="rightpad20" href="https://www.facebook.com/digibytecoin/" target="_blank"><i class="fab fa-facebook zoom"></i></a>
					   <a class="rightpad20" href="https://www.linkedin.com/company/digibyte-payment-network" target="_blank"><i class="fab fa-linkedin zoom"></i></a>
					   <a class="rightpad20" href="https://www.instagram.com/officialdigibytecoin/" target="_blank"><i class="fab fa-instagram zoom"></i></a>
					   <a class="rightpad20" href=https://www.youtube.com/@DigiByteGlobalCommunity/ target="_blank"><i class="fab fa-youtube zoom"></i></a>
					   <a class="rightpad20" href="https://www.reddit.com/r/DigiByte/" target="_blank"><i class="fab fa-reddit zoom"></i></a>
					   <a href="https://medium.com/@DigiByte_Official" target="_blank"><i class="fab fa-medium-m zoom"></i></a>
                    </p>
                </div>
            </div>
		
			<div class="col-block item-feature" id="telegram">
                <div class="item-feature__icon">
                    <i class="fab fa-telegram-plane"></i>
                </div>
                <div class="item-feature__text">
                    <h3 class="item-title">Telegram groups.</h3>
                    <p><a href="https://telegram.org" target="_blank">Telegram</a> is the most popular and simple way to engage with the global DigiByte community. Please join the groups below which you are interested in or see the list of <a href="https://t.me/OfficialDigiByteGroups" target="_blank">all DigiByte groups</a>.
					</p>
					<p>
					<a class="telegramicon" href="https://t.me/DGBalerts" target="_blank"><i class="fab fa-telegram-plane"></i> Alerts</a>
					<a class="telegramicon" href="https://t.me/DigiByteCoin" target="_blank"><i class="fab fa-telegram-plane"></i> Discussion</a>
					<a class="telegramicon" href="https://dgbsupport.digiassetx.com" data-lity><i class="fab fa-telegram-plane"></i> Support</a>
					<a class="telegramicon" href="https://t.me/DigiByteDevelopers" target="_blank"><i class="fab fa-telegram-plane"></i> Developers</a>
					<a class="telegramicon" href="https://t.me/dgbmining" target="_blank"><i class="fab fa-telegram-plane"></i> Mining</a>
					<a class="telegramicon" href="https://t.me/DigiByteMarketing" target="_blank"><i class="fab fa-telegram-plane"></i> Marketing</a>
					<a class="telegramicon" href="https://t.me/dgbwaves" target="_blank"><i class="fab fa-telegram-plane"></i> Speculation</a>
					<a class="telegramiconlast" href="https://t.me/DigiByteTranslations" target="_blank"><i class="fab fa-telegram-plane"></i> Translations</a>
					</p>
                </div>
            </div>
		
		</div>
		
		<div class="row features block-1-2 block-m-1-2 topcom" data-aos="fade">
		
			<div class="col-block item-feature" id="wiki">
                <div class="item-feature__icon">
                    <i class="fab fa-wikipedia-w"></i>
                </div>
                <div class="item-feature__text">
                    <h3 class="item-title">The DigiByte Wiki.</h3>
                    <p>The <a href="https://github.com/DigiByte-Core/digibyte/wiki" target="_blank">DigiByte Wiki</a> is an online encyclopedia built by the community, for the community. It contains useful and up to date data such as the <a href="https://github.com/DigiByte-Core/digibyte/wiki#digibyte-blockchain" target="_blank"> DigiByte Ecosystem</a> and <a href="https://github.com/DigiByte-Core/digibyte/wiki/Contribution-Guidelines" target="_blank">how to guides</a>. Anyone can positively contribute to the Wiki by creating a free user account and start adding or updating information on the DigiByte Wiki.<br><strong>Warning</strong> <i class="fas fa-exclamation-circle"></i> Avoid shameless self-promotion and referral links.</p>
					<p class="jared">
					<a class="telegramicon" href="https://github.com/DigiByte-Core/digibyte/wiki#technical-specifications" target="_blank"><i class="fab fa-wikipedia-w"></i> Technical</a> 
					<a class="telegramicon" href="https://github.com/DigiByte-Core/digibyte/wiki#framework" target="_blank"><i class="fab fa-wikipedia-w"></i> Framework</a>
					<a class="telegramicon" href="https://github.com/DigiByte-Core/digibyte/wiki#accomplishments" target="_blank"><i class="fab fa-wikipedia-w"></i> Accomplishments</a>
					</p>
                </div>
            </div>
		
			<div class="col-block item-feature" id="jared">
                <div class="item-feature__icon">
                    <i class="fas fa-user-tie"></i>
                </div>
                <div class="item-feature__text">
                    <h3 class="item-title">Meet the creator of DigiByte.</h3>
                    <p><a href="https://www.youtube.com/embed/S8eMsq8qp7Y?autoplay=1&loop=1&modestbranding=1&iv_load_policy=3&rel=0&showinfo=0" data-lity>Jared Tate</a> is the founder and creator of the DigiByte blockchain. Jared dedicated full-time development towards DigiByte since October 2013. He has been invited by <a href="https://www.youtube.com/embed/Wl0RUau9roE?autoplay=1&iv_load_policy=3&rel=0" data-lity>MIT</a>, <a href="https://x.com/digibytecoin/status/982696268928618496" target="_blank">Harvard</a> and the <a href="https://x.com/jaredctate/status/1217178454229225473" target="_blank">US Capitol</a> to speak on blockchain tech. He is also the co-author of the book <a href="https://www.amazon.com/Blockchain-2035-Digital-DNA-Internet-ebook/dp/B07ZVCC36Q" target="_blank">Blockchain 2035 The Digital DNA of Internet 3.0</a>, which is the first book written by a blockchain founder.
                    </p>
					<p class="jared">
					<a class="telegramicon" href="https://x.com/jaredctate" target="_blank"><i class="fa-brands fa-x-twitter"></i></a> 
					<a class="telegramicon" href="https://www.linkedin.com/in/jaredctate" target="_blank"><i class="fab fa-linkedin-in"></i> LinkedIn</a>
					<a class="telegramicon" href="https://github.com/DigiByte-Core/digibyte/wiki#original-authors" target="_blank"><i class="fab fa-wikipedia-w"></i> Biography</a>
					</p>
                </div>
            </div>
			
		</div>
	    
			 <div class="lrmargin25" data-aos="fade">
				 
		      <div class="item-feature__text max800 align-center">
                <p class="disc"><i class="fas fa-exclamation-triangle"></i> <strong>Social Media Disclaimer</strong><br>The personal opinion, beliefs and viewpoints expressed by Jared Tate, DigiByte Core Team, DigiByte Alliance & DigiByte Awareness Team do not necessarily reflect the personal opinion, beliefs and viewpoints of the community.
                </p>
		      </div>
		
	         </div>
		
		<div class="testimonials-wrap" data-aos="fade" id="contribute">
	    
	      <div class="row">
                <div class="col-full testimonials-header">
                    <h2 class="display-2">Contribute to the DigiByte community.</h2>
                </div>
            </div>

            <div class="row testimonials">

                <div class="col-full slick-slider testimonials__slider">

                    <div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/changeangel2.png" loading="lazy" width="72" height="72" alt="Changeangel" class="testimonials__avatar">
                        
                        <p>Changeangel is a crypto to crypto, wallet to wallet, swap exchange service that supports community projects.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Changeangel</span>
                            <a href="https://changeangel.io" target="_blank" class="testimonials__link">changeangel.io</a> - <a href="https://changeangel.io/buy-dgb" target="_blank" class="testimonials__link">buy dgb</a>
                        </div>
                    </div>

                </div>
	    
	        </div>
	  </div>
	    
	</section>


   <!-- Downloads
    ================================================== -->
    <section id="downloads" class="s-download target-section">
	    
	<!--- Downloads DigiByte Wallets
    ================================================== -->
        <div class="row section-header has-bottom-sep" data-aos="fade-up">
            <div class="col-full">
                <h1 class="display-1">
                    Choose your app.
                </h1>
                <p class="lead">
                    Select an application to send, accept and store your DigiByte & DigiAssets or securely authenticate by using Digi-ID.<br /><a href="https://github.com/DigiByte-Core/digibyte/releases/" target="_blank">Current DigiByte Core v7.17.3</a>
                </p>
            </div>
			<a class="btn wb playb" href="https://www.youtube.com/embed/sRxpgJkvRK8?autoplay=1&loop=1&modestbranding=1&iv_load_policy=3&rel=0&showinfo=0" data-lity><i class="fas fa-play"></i> Learn by watching</a>
        </div>
		
		<div data-aos="fade">
			
            <h1 class="downtitle align-center">Protocol & Wallet <br>All in One</h1>
		
            <div class="item-feature__text max830 align-center">
                <p>DigiByte Core contains a full copy of the blockchain and builds the backbone of the network.
                It is commonly used by developers, exchanges, and other businesses, as well as by community members, to decentralize the network by running a full node.
                It also doubles as a software wallet.
                </p>
		    </div>

        
		
            <div class="row features block-1-2 block-m-1-2 block-tab-full stack max880">

                <div id="dgbcore">
                    <div class="item-plan__block-wrapper">
                        <div class="item-plan__block"> 

                            <div id="dgbcore_symbol"></div>
                            
                            <div class="item-plan__top-part">
                                <p class="item-plan__price">DigiByte Core</p>
                            </div>
        
                            <div class="item-plan__bottom-part">
                                <ul class="item-plan__features">
                                <li><i class="fas fa-check blue"></i> Full validation</li>
                                <li><i class="fas fa-check blue"></i> Support the network</li>
                                <li><i class="fas fa-check blue"></i> High stability</li>
                                <li><i class="fas fa-check blue"></i> SegWit support</li>
                                </ul>
                                
                                <div class="appsicon align-center">
                                <a class="rightpad25" href="https://github.com/DigiByte-Core/digibyte/releases/download/v7.17.3/digibyte-7.17.3-win64-setup-signed.exe" target="_blank"><i class="fab fa-windows zoom"></i></a>
                                <a class="rightpad25" href="https://github.com/DigiByte-Core/digibyte/releases/download/v7.17.3/digibyte-7.17.3-osx-unsigned.dmg" target="_blank"><i class="fab fa-apple zoom"></i></a>
                                <a class="rightpad25" href="https://github.com/DigiByte-Core/digibyte/releases/download/v7.17.3/digibyte-7.17.3-x86_64-linux-gnu.tar.gz" target="_blank"><i class="fab fa-linux zoom"></i></a>
                                    <a href="https://snapcraft.io/digibyte-core" target="_blank">
                                        <svg class="zoom" width="44px" height="69px" viewbox="0 0 33 33" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="vertical-align: middle;">
                                            <g id="[EN]-snap-store-white-uneditable" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <g id="logo" fill-rule="nonzero">
                                                    <path d="M18.9875172,17.8017143 L18.9875172,7.33085714 L26.2054138,10.5525714 L18.9875172,17.8017143 Z M5.20774138,31.6411429 L14.058569,14.9742857 L17.9423276,18.852 L5.20774138,31.6411429 Z M0.160180862,0.233262857 L18.3753103,6.84571429 L18.3753103,18.4171429 L0.160180862,0.233262857 Z" id="body" fill="#06c"></path>
                                                    <polygon id="head" fill="#06c" points="29.8968621 6.84514286 19.4057069 6.84514286 32.8936034 12.8657143"></polygon>
                                                </g>
                                            </g>
                                        </svg>
                                    </a>
                                </div>
        
                                <div class="supportline align-center">
                                <p class="item-plan__per">Available for Windows, macOS, Linux & Snapcraft (64 Bit)</p>
                                </div>
                                
                                <div class="supportline align-center pt2">
                                <a href="https://dgbsupport.digiassetx.com" data-lity><i class="fas fa-user-headset"></i> Support</a> - <a href="https://github.com/DigiByte-Core/digibyte/wiki/Run-a-Open-Full-Node" target="_blank"><i class="fas fa-info-circle"></i>  Run a full node</a>
                                </div>
                            </div>  
                            
                        </div>
                    </div>
                    <div class="lrmargin25">
                    
                        <div class="item-feature__text max800 align-center">
                        <p>
                            <i class="fas fa-exclamation-triangle"></i>
                            <strong>Wallet Disclaimer</strong>
                            <br>
                            DigiByte Core as a wallet should be used by advanced users only, who knows how to keep their wallet secure.
                            If you are not an experienced user, you may want to use a simplified <a class="smoothscroll" href="#software">software wallet</a>.
                        </p>
                        </div>
                        
                    </div>
                </div>
            </div>
		</div>
	    
	    	<!--- Downloads Docs & Guides
    ================================================== -->
	    	<div class="lrmargin25" data-aos="fade"  id="docs">
		
			<h1 class="downtitle align-center"><i class="fas fa-books"></i> DigiByte Documents & Guides.</h1>
				
			  <div class="item-feature__text max800 align-center">
                  <p>Looking for more documentation? Whether you need basic information for an article or technical information for an integration process. You can reach all the necessary guides below.
                  </p>
              </div>
     
		    <div class="row testimonials downslide">

                <div class="col-full slick-slider testimonials__slider">
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/infopaper.png" loading="lazy" width="72" height="72" alt="DigiByte Info Paper" class="testimonials__avatar">
                        
                        <p>Learn the details of the DigiByte blockchain by using the community info paper.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Info paper</span>
                            <a href="https://www.digibyte.org/docs/infopaper.pdf" target="_blank" class="testimonials__link">Download</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/integration.png" loading="lazy" width="72" height="72" alt="DigiByte Integration Guide" class="testimonials__avatar">
                        
                        <p>Integrate the DigiByte blockchain into your exchange, wallet or service easily.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Integration guide</span>
                            <a href="https://www.digibyte.org/docs/integrationguide.pdf" target="_blank" class="testimonials__link">Download</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/mediag.png" loading="lazy" width="72" height="72" alt="DigiByte Media Sheet" class="testimonials__avatar">
                        
                        <p>Learn the important facts about the DigiByte blockchain by the media sheet quickly.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Media sheet</span>
                            <a href="https://www.digibyte.org/docs/mediakit.pdf" target="_blank" class="testimonials__link">Download</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
						<img src="https://www.digibyte.org/images/avatars/presentation.png" loading="lazy" width="72" height="72" alt="DigiByte Presentation" class="testimonials__avatar">
                        
                        <p>Use the informative online presentation to introduce DigiByte to your friends.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Presentation</span>
                            <a href="https://docs.google.com/presentation/d/16Hn2GfuS1yLjZpjeTYloW0S_JVkhevYzffkDZFqjbiU" target="_blank" class="testimonials__link">Start</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/logos.png" loading="lazy" width="72" height="72" alt="DigiByte Logos & Icons" class="testimonials__avatar">
                        
                        <p>Find the correct and up to date DigiByte logos & icons for your project.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Logos & Icons</span>
                            <a href="https://github.com/DigiByte-Core/digibyte-logos" target="_blank" class="testimonials__link">Go to GitHub</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/avatars/howto.png" loading="lazy" width="72" height="72" alt="How to Guides" class="testimonials__avatar">
                        
                        <p>Run your own DigiByte full node or Insight explorer by referring the Wiki guides.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">How to guides</span>
                            <a href="https://github.com/DigiByte-Core/digibyte/wiki/Contribution-Guidelines" target="_blank" class="testimonials__link">Go to DigiByte Wiki</a>
                        </div>
                    </div>
                    
                </div>

            </div>
	</div>
	    
	<!--- Downloads Third-Party
    ================================================== -->
		<div class="lrmargin25" data-aos="fade" id="software">
	<h1 class="downtitle align-center">Apps developed by a Third-Party service.</h1>
			
	<!--- Downloads Third-Party Software Wallets
    ================================================== -->
        <h2 class="downtitle align-center"><i class="fas fa-laptop-code"></i> Software wallets.</h2>

		<div class="row testimonials downslide">

                <div class="col-full slick-slider testimonials__slider">
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/coinomi.png" loading="lazy" width="72" height="72" alt="Coinomi Wallet" class="testimonials__avatar">
                        
                        <p>Available on Windows, macOS, Linux, iOS and Android. Digi-ID and SegWit support. <strong class="dark">Recommended!</strong></p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Coinomi</span>
                            <a href="https://www.coinomi.com/asset/digibyte/" target="_blank" class="testimonials__link">Download</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/ownbit.png" loading="lazy" width="72" height="72" alt="Ownbit Wallet" class="testimonials__avatar">
                        
                        <p>Available on iOS and Android. Digi-ID and MultiSig support. <strong>Paid membership</strong>.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Ownbit</span>
                            <a href="https://ownbit.io" target="_blank" class="testimonials__link">Download</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/edge.png" loading="lazy" width="72" height="72" alt="Edge Wallet" class="testimonials__avatar">
                        
                        <p>Available on iOS and Android. SegWit support.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Edge</span>
                            <a href="https://edge.app" target="_blank" class="testimonials__link">Download</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/exodus.png" loading="lazy" width="72" height="72" alt="Exodus Wallet" class="testimonials__avatar">
                        
                        <p>Available on Windows, macOS, Linux, iOS and Android.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Exodus</span>
                            <a href="https://www.exodus.io/digibyte-wallet" target="_blank" class="testimonials__link">Download</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/atomic.png" loading="lazy" width="72" height="72" alt="Atomic Wallet" class="testimonials__avatar">
                        
                        <p>Available on Windows, macOS, Linux, iOS and Android.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Atomic</span>
                            <a href="https://atomicwallet.io/digibyte-wallet" target="_blank" class="testimonials__link">Download</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/trust.png" loading="lazy" width="72" height="72" alt="Trust Wallet" class="testimonials__avatar">
                        
                        <p>Available on iOS and Android. SegWit support.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Trust Wallet</span>
                            <a href="https://trustwallet.com/digibyte-wallet" target="_blank" class="testimonials__link">Download</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/guarda1.png" loading="lazy" width="72" height="72" alt="Guarda Wallet" class="testimonials__avatar">
                        
                        <p>Available on Windows, macOS, Linux, Chrome, iOS and Android.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Guarda</span>
                            <a href="https://guarda.com" target="_blank" class="testimonials__link">Download</a>
                        </div>
                    </div>
					
                </div>

            </div>
			</div>
	    
	  <!--- Downloads Third-Party Hardware Wallets
    ================================================== -->
		    <div class="lrmargin25 top30" data-aos="fade"  id="hardware">

		    <h2 class="downtitle align-center"><i class="fas fa-microchip"></i> Hardware wallets.</h2>
     
		    <div class="row testimonials downslide">

                <div class="col-full slick-slider testimonials__slider">
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/bitfi.png" loading="lazy" width="72" height="72" alt="Bitfi Wallet" class="testimonials__avatar">
                        
                        <p>Works on any web browser through Wi-Fi. SegWit support. <strong class="dark">Recommended!</strong></p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Bitfi</span>
                            <a href="https://bitfi.com" target="_blank" class="testimonials__link">Visit website</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/ledger.png" loading="lazy" width="72" height="72" alt="Ledger Wallet" class="testimonials__avatar">
                        
                        <p>Works on Win, macOS, Linux, iOS and Android through USB and Bluetooth. SegWit support. <strong class="dark">Recommended!</strong></p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Ledger</span>
                            <a href="https://www.ledger.com/digibyte-wallet/" target="_blank" class="testimonials__link">Visit website</a>
                        </div>
                    </div>
					
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/keepkey.png" loading="lazy" width="72" height="72" alt="KeepKey Wallet" class="testimonials__avatar">
                        
                        <p>Works on Chrome and ShapeShift.com through USB.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">KeepKey</span>
                            <a href="https://shapeshift.com/keepkey" target="_blank" class="testimonials__link">Visit website</a>
                        </div>
                    </div>
					
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/safepal.png" loading="lazy" width="72" height="72" alt="SafePal Wallet" class="testimonials__avatar">
                        
                        <p>Works on iOS and Android through QR code. SegWit support.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">SafePal</span>
                            <a href="https://www.safepal.io" target="_blank" class="testimonials__link">Visit website</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/secux.png" loading="lazy" width="72" height="72" alt="SecuX Wallet" class="testimonials__avatar">
                        
                        <p>Works on Chrome and iOS through USB and Bluetooth. SegWit support.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">SecuX</span>
                            <a href="https://www.secuxtech.com" target="_blank" class="testimonials__link">Visit website</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/dcent.png" loading="lazy" width="72" height="72" alt="D'CENT Wallet" class="testimonials__avatar">
                        
                        <p>Works on iOS and Android through USB and Bluetooth. Biometric authentication and SegWit support.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">D'CENT</span>
                            <a href="https://dcentwallet.com" target="_blank" class="testimonials__link">Visit website</a>
                        </div>
                    </div>
                    
                </div>

            </div>
			</div>
		
	<!--- Downloads Third-Party Debit Cards
    ================================================== -->
		    <div class="lrmargin25 top30" data-aos="fade" id="cards">
			
			<h2 class="downtitle align-center"><i class="fas fa-credit-card"></i> Debit cards.</h2>
     
		    <div class="row testimonials downslide">

                <div class="col-full slick-slider testimonials__slider">
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/cryptocom.png" loading="lazy" width="72" height="72" alt="Crypto.com" class="testimonials__avatar">
                        
                        <p>Custodial iOS and Android apps. Visa debit card.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Crypto.com</span>
                            <a href="https://crypto.com/cards" target="_blank" class="testimonials__link">Get the app</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/bitpanda.png" loading="lazy" width="72" height="72" alt="Bitpanda" class="testimonials__avatar">
                        
                        <p>Custodial iOS and Android apps. Visa debit card.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Bitpanda</span>
                            <a href="https://www.bitpanda.com/card" target="_blank" class="testimonials__link">Get the app</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/upholdcard.png" loading="lazy" width="72" height="72" alt="Uphold" class="testimonials__avatar">
                        
                        <p>Custodial iOS and Android apps. MasterCard debit card.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Uphold</span>
                            <a href="https://uphold.com/debit-card" target="_blank" class="testimonials__link">Get the app</a>
                        </div>
                    </div>
                    
                </div>

            </div>
			</div>
		
	<!--- Downloads Third-Party Point of Sale Apps
    ================================================== -->
		    <div class="lrmargin25 top30" data-aos="fade" id="posapps">
			
			<h2 class="downtitle align-center"><i class="fas fa-shopping-cart"></i> Point of sale apps.</h2>
     
		    <div class="row testimonials downslide">

                <div class="col-full slick-slider testimonials__slider">
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/coinpayments2.png" loading="lazy" width="72" height="72" alt="Coinpayments" class="testimonials__avatar">
                        
                        <p>Custodial iOS and Android apps for in-person payments and plugins for online payments. Auto-sell support.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">CoinPayments</span>
                            <a href="https://www.coinpayments.net" target="_blank" class="testimonials__link">Get the app</a>
                        </div>
                    </div>
                    
                </div>

            </div>
			</div>
		
	<!--- Downloads Third-Party Digi-ID Apps
    ================================================== -->
		    <div class="lrmargin25 top30" data-aos="fade" id="digidapps">
		
			<h2 class="downtitle align-center"><i class="fas fa-fingerprint"></i> Digi-ID apps.</h2>
     
		    <div class="row testimonials downslide">

                <div class="col-full slick-slider testimonials__slider">
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/digiantumid.png" loading="lazy" width="72" height="72" alt="Digi-ID/AntumID" class="testimonials__avatar">
                        
                        <p>Digi-ID authenticator app. AntumID extensions support for DigiPassword function.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Digi-ID/AntumID</span>
                            <a href="https://apps.apple.com/app/digi-id-antumid/id1457498829" target="_blank" class="testimonials__link">iOS</a> - <a href="https://play.google.com/store/apps/details?id=rocks.digibyte.digiid" target="_blank" class="testimonials__link">Android</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/coinomi.png" loading="lazy" width="72" height="72" alt="Coinomi" class="testimonials__avatar">
                        
                        <p>Multi currency wallet with Digi-ID authenticator function.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Coinomi</span>
                            <a href="https://apps.apple.com/app/coinomi-wallet/id1333588809" target="_blank" class="testimonials__link">iOS</a> - <a href="https://play.google.com/store/apps/details?id=com.coinomi.wallet" target="_blank" class="testimonials__link">Android</a>
                        </div>
                    </div>
					
					<div class="testimonials__slide">
                        <img src="https://www.digibyte.org/images/wallets/ownbit.png" loading="lazy" width="72" height="72" alt="Ownbit Wallet" class="testimonials__avatar">
                        
                        <p>Multi currency wallet with Digi-ID authenticator function.</p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Ownbit</span>
                            <a href="https://apps.apple.com/app/ownbit/id1321798216" target="_blank" class="testimonials__link">iOS</a> - <a href="https://play.google.com/store/apps/details?id=com.bitbill.www" target="_blank" class="testimonials__link">Android</a>
                        </div>
                    </div>

                    <div class="testimonials__slide">
                        <img src="/images/avatars/digi-id_desktop-screen.svg" loading="lazy" width="72" height="72" alt="Digi-ID Desktop" class="testimonials__avatar">

                        <p>
                            Digi-ID for Desktop Computers.
                            <br>
                            <a href="https://github.com/RenzoDD/digiid-desktop" class="testimonials__link" title="View on Github"><i class="fab fa-github"></i></a>
                        </p>

                        <div class="testimonials__author">
                            <span class="testimonials__name">Digi-ID Desktop</span>
                            <a href="https://github.com/RenzoDD/digiid-desktop/releases/" target="_blank" class="testimonials__link">Releases</a>
                        </div>
                    </div>
                    
                </div>

            </div>
			</div>

            <div class="lrmargin25 top30" data-aos="fade" id="tools-solutions"> 
                <h2 class="downtitle align-center"><i class="fas fa-server"></i> Tools & Solutions.</h2>
                
                <div class="row testimonials downslide">
                    
                    <div class="col-full slick-slider testimonials__slider">

                        <div class="testimonials__slide">
                            <img src="https://www.digibyte.org/images/avatars/diginode_round.svg" loading="lazy" width="72" height="72" alt="Digi-ID Desktop" class="testimonials__avatar">
    
                            <p>
                                DigiNode Tools makes it easy to set up, monitor and manage your own DigiByte full node and DigiAssets node on a Raspberry Pi or other Ubuntu/Debian system.
                            </p>
    
                            <div class="testimonials__author">
                                <span class="testimonials__name">DigiNode Tools</span>
                                <a href="https://diginode.tools" target="_blank" class="testimonials__link">Visit website</a>
                            </div>
                        </div>

                        <div class="testimonials__slide">
                            <img src="https://www.digibyte.org/images/avatars/getblock-inverted-primary-icon.svg" loading="lazy" width="72" height="72" alt="GetBlock" target="_blank" class="testimonials__avatar">

                            <p>DigiByte Node Endpoints.<br>Blockchain RPC API.</p>

                            <div class="testimonials__author">
                                <span class="testimonials__name">GetBlock</span>
                                <a href="https://getblock.io/nodes/dgb/" target="_blank" class="testimonials__link">Go to DigiByte API</a>
                            </div>
                        </div>

                        <div class="testimonials__slide">
                            <img src="https://www.digibyte.org/images/avatars/nownodes-square-custom-logo.svg" loading="lazy" width="72" height="72" alt="NOWNodes" target="_blank" class="testimonials__avatar">

                            <p>DigiByte Node Endpoints.<br>Blockchain RPC & Explorer API</p>

                            <div class="testimonials__author">
                                <span class="testimonials__name">NowNodes</span>
                                <a href="https://nownodes.io/nodes/digibyte-dgb" target="_blank" class="testimonials__link">Go to DigiByte API</a>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
		
		    <div class="lrmargin25" data-aos="fade">
				
		      <div class="item-feature__text max800 align-center">
                <p class="disc"><i class="fas fa-exclamation-triangle"></i> <strong>Wallet Disclaimer</strong><br>All the Third-Party wallets introduced here are hosted by their own servers or application stores. We have no responsibility for possible issues you may have about any Third-Party wallet. In such case you should contact the related wallet's support service.
                </p>
              </div>
				
	       </div>

    </section>


    <!-- Footer
    ================================================== -->
    <footer id="footer" class="s-footer footer">
		
		<div class="align-center">
			<a class="smoothscroll" href="#top"><img src="https://www.digibyte.org/images/footerlogo.png" loading="lazy" width="360" height="139" alt="DigiByte Blockchain" class="footerlogo"></a>
		</div>
		
		<div class="row footer__top max1000">
            <div class="col-full footer__subscribe end">
                <div class="subscribe-form">
					<form id="de-form" class="group" method="get" target="_blank" action="https://chainz.cryptoid.info/dgb/search.dws?key=25ac5ef2ff1e">
                       <input type="text" name="q" placeholder="Search for block, tx id or address" autocomplete="off" required>
                       <a><input type="submit" value="Search" class="btn btn--primary home-content__btn search"></a>
                    </form>
                </div>
            </div>
        </div>

        <div class="row align-center">
            <div class="col-full">
                <p>
					<a class="telfooter15" href="https://t.me/DGBalerts" target="_blank"><i class="fab fa-telegram-plane"></i> Alerts</a>
					
                    <a class="telfooter15" href="https://t.me/DigiByteCoin" target="_blank"><i class="fab fa-telegram-plane"></i> Discussion</a>
					
					<a class="telfooter15" href="https://dgbsupport.digiassetx.com" data-lity><i class="fab fa-telegram-plane"></i> Support</a>
					
					<a class="telfooter15" href="https://t.me/DigiByteDevelopers" target="_blank"><i class="fab fa-telegram-plane"></i> Developers</a>
					
					<a class="telfooter15" href="https://t.me/dgbmining" target="_blank"><i class="fab fa-telegram-plane"></i> Mining</a>
					
					<a class="telfooter15" href="https://t.me/DigiByteMarketing" target="_blank"><i class="fab fa-telegram-plane"></i> Marketing</a>
			
					<a class="telfooter15" href="https://t.me/dgbwaves" target="_blank"><i class="fab fa-telegram-plane"></i> Speculation</a>
			
					<a class="iblock" href="https://t.me/DigiByteTranslations" target="_blank"><i class="fab fa-telegram-plane"></i> Translations</a>
                </p>
            </div>
        </div> 


        <div class="row footer__bottom">

            <div class="footer__about col-five tab-full left">

                <h4>About DigiByte.</h4>

                <p>
                DigiByte is a rapidly growing open-source blockchain created in late 2013 and released in early 2014. After <span class="year-diff"></span> years of forward thinking development, DigiByte has become one of the safest, fastest, longest and most decentralized UTXO blockchain in existence.<br>
		        DigiByte is global in 100+ countries.
                </p>

                <ul class="footer__social">
		            <li><a class="zoom" href="https://x.com/DigiByteCoin" target="_blank"><i class="fa-brands fa-x-twitter"></i></a></li>
                    <li><a class="zoom" href="https://www.facebook.com/digibytecoin/" target="_blank"><i class="fab fa-facebook-f" aria-hidden="true"></i></a></li>
                    <li><a class="zoom" href="https://www.linkedin.com/company/digibyte-payment-network" target="_blank"><i class="fab fa-linkedin-in" aria-hidden="true"></i></a></li>
                    <li><a class="zoom" href="https://www.instagram.com/officialdigibytecoin/" target="_blank"><i class="fab fa-instagram" aria-hidden="true"></i></a></li>
		            <li><a class="zoom" href=https://www.youtube.com/@DigiByteGlobalCommunity/ target="_blank"><i class="fab fa-youtube" aria-hidden="true"></i></a></li>
		            <li><a class="zoom" href="https://www.reddit.com/r/DigiByte/" target="_blank"><i class="fab fa-reddit-alien" aria-hidden="true"></i></a></li>
					<li><a class="zoom" href="https://medium.com/@DigiByte_Official" target="_blank"><i class="fab fa-medium-m" aria-hidden="true"></i></a></li>
					<li><a class="zoom" href="https://t.me/DigiByteCoin" target="_blank"><i class="fab fa-telegram-plane" aria-hidden="true"></i></a></li>
                    <li><a class="zoom" href="https://dsc.gg/DigiByteDiscord" target="_blank"><i class="fab fa-discord" aria-hidden="true"></i></a></li>
                </ul>
            </div>

            <div class="col-six md-seven tab-full right end">
                <div class="row">

                    <div class="footer__site-links col-six mob-full">
                        <h4>DigiByte links.</h4>

                        <ul class="footer__site-links">
                            <li><a href="https://www.dgballiance.org" target="_blank">DigiByte Alliance</a></li>
                            <li><a href="https://dgbat.org" target="_blank">DGB Awareness Team</a></li>
                            <li><a href="https://github.com/DigiByte-Core/digibyte/wiki" target="_blank">DigiByte Wiki</a></li>
			                <li><a href="https://digiexplorer.info" target="_blank">DigiExplorer</a></li>
							<li><a href="https://digibyte.io" target="_blank">DigiStats</a></li>
							<li><a href="https://dgbwiki.com/index.php?title=DigiByte#DigiByte_Mining" target="_blank">DigiByte Mining</a></li>
			                <li><a href="https://www.amazon.com/Blockchain-2035-Digital-DNA-Internet-ebook/dp/B07ZVCC36Q" target="_blank">Blockchain 2035</a></li>
                        </ul>
                    </div>

                    <div class="footer__contact col-six mob-full">
                        <h4>Resources.</h4>

                        <ul class="footer__site-links">
                            <li><a href="https://www.digibyte.org/docs/integrationguide.pdf" target="_blank">DGB Integration Guide</a></li>
                            <li><a href="https://www.digibyte.org/docs/mediakit.pdf" target="_blank">DGB Media Sheet</a></li>
                            <li><a href="https://github.com/DigiByte-Core/digibyte-logos" target="_blank">DGB Logos & Icons</a></li>
			                <li><a href="https://github.com/DigiByte-Core/digibyte" target="_blank">DGB Protocol GitHub</a></li>
                            <li><a href="https://github.com/digibyte-core" target="_blank">DGB Core GitHub</a></li>
                        </ul>
                    </div>		

                </div>
            </div>

            <div class="col-full ss-copyright"> 
                <span>&copy; Copyright <span id="copyright-year"></span></span> 
				<span>All Rights Reserved</span> 
                <span>Released under the <a href="https://opensource.org/licenses/mit-license.php" target="_blank">MIT license</a></span> 
				<span><a href="https://www.digibyte.org/docs/LegalDisclaimer.pdf">Legal Disclaimer</a> | <a href="https://www.digibyte.org/docs/PrivacyPolicy.pdf">Privacy Policy</a></span>
            </div>

        </div>

        
        <div class="go-top">
            <a class="smoothscroll" title="Back to Top" href="#top"></a>
        </div>

    </footer>


    <!-- Java Script
    ================================================== -->
    <script src="https://www.digibyte.org/js/jquery-3.5.1.min.js"></script>
    <script src="https://www.digibyte.org/js/plugins1b.js"></script>
    <script src="https://www.digibyte.org/js/main2o.js"></script>
	
	<!-- Cookie info message
    ================================================== -->
	<script type="text/javascript" id="cookieinfo" src="https://www.digibyte.org/js/cookieinfo.min.js"
	data-font-size="14px"
	data-font-family="Nunito Sans,sans-serif"
	data-text-align="left"
    data-fg="#545454"
	data-bg="rgba(255, 255, 255, 0.9)"
	data-link="#0066cc"
	data-divlink="#ffffff"
	data-divlinkbg="#0066cc"
	data-position="bottom"
	data-message="We use cookies to enhance your experience. By continuing to visit this site you agree to our use of cookies."
	data-linkmsg="More info"
	data-moreinfo="https://www.digibyte.org/docs/PrivacyPolicy.pdf"
	data-close-text="OK"
	>
    </script>
    <script>
        if (!navigator.serviceWorker.controller) {
            navigator.serviceWorker.register("/js/sw.js").then(function(reg) {
                console.log("Service worker has been registered for scope: " + reg.scope);
            });
        }       
    </script>
</body>
	
</html>

<?php /**PATH /home/stellar/public_html/core/resources/views/templates/basic/sections/banner.blade.php ENDPATH**/ ?>