
<?php $__env->startSection('content'); ?>
    <?php
        $content = getContent('user_dashboard.content', true);
    ?>

    <div class="card custom--card text--white mb-5">
        <div class="card-header py-3">
            <h5 class="card-title m-0"><?php echo e(__($pageTitle)); ?></h5>
        </div>
        <div class="card-body py-5">
            <form class="withdraw--form row mb--25" id="withdrawForm">
                <?php echo csrf_field(); ?>
                <div class="form-group col-lg-10">
                    <div class="input-group m-0">
                        <input class="form-control form--control" name="amount" type="text" placeholder="Balance: <?php echo e($track->balance); ?>">
                        <div class="input-group-append"></div>
                        <span class="input-group-text bg--base border--light text--white"><?php echo e(__($general->cur_text)); ?></span>
                    </div>
                   
                </div>
                <div class="form-group col-lg-2">
                    <button class="cmn--btn form-control form--control d-block" id="submitBtn" type="submit"><?php echo app('translator')->get('SUBMIT'); ?></button>
                </div>
            </form>
        </div>
        <div class="card-footer py-3">
            <div class="row">
                <span class="col-lg-6"><?php echo app('translator')->get('Minimum Limit'); ?>: <?php echo e($gateway->minimum_withdraw); ?> <?php echo e(__($general->cur_text)); ?></span>

                <span class="col-lg-6"><?php echo app('translator')->get('Maximum Limit'); ?>: <?php echo e($gateway->maximum_withdraw); ?> <?php echo e(__($general->cur_text)); ?></span>

            </div>
        </div>
    </div>
    <div class="active--miners">
        <h4 class="subtitle mb-4 pt-5 text-white"><?php echo app('translator')->get('Your Withdrawals'); ?></h4>
        <div class="table--responsive">
            <table class="cmn--table table--white">
                <thead>
                    <tr>
                        <th><?php echo app('translator')->get('TIME'); ?></th>
                        <th><?php echo app('translator')->get('TRX NUMBER'); ?></th>
                        <th><?php echo app('translator')->get('AMOUNT'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <?php echo e(showDateTime($item->created_at)); ?>

                            </td>
                            <td>
                                <span><?php echo e($item->trx); ?></span>
                            </td>
                            <td>
                                <span><?php echo e(showAmount($item->amount, 8)); ?> <?php echo e(__($general->cur_text)); ?></span>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td class="text-center" colspan="100%"><?php echo app('translator')->get('NO DATA AVAILABLE'); ?></td>
                        </tr>
                    <?php endif; ?>

                </tbody>
            </table>
            <?php if($withdrawals->hasPages()): ?>
                <?php echo e(paginateLinks($withdrawals)); ?>

            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            $('#withdrawForm').on('submit', function(e) {
                e.preventDefault();
                let minLimit = parseFloat('<?php echo e($gateway->minimum_withdraw); ?>');
                let maxLimit = parseFloat('<?php echo e($gateway->maximum_withdraw); ?>');
                let inputAmount = parseFloat($(`[name="amount"]`).val());
                if (!inputAmount) {
                    notify('error', 'Withdraw amount required');
                } else if (inputAmount > maxLimit) {
                    notify('error', 'Please follow maximum withdraw limit');
                } else if (inputAmount < minLimit) {
                    notify('error', 'Please follow minimum withdraw limit');
                } else {
                    $('#submitBtn').attr('disabled', 'disabled');
                    notify("warning", 'The request is processing. Please wait for some time');
                    var data = $(this).serialize();
                    $.ajax({
                        type: "POST",
                        url: "<?php echo e(route('account.withdraw')); ?>",
                        data: data,
                        dataType: "json",
                        success: function(data) {
                            if (data.error) {
                                notify('error', data.error);
                                $('#submitBtn').removeAttr('disabled');
                            } else {
                                notify("success", data.success);
                            }
                        }
                    });
                }


            });
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/solana/public_html/4/core/resources/views/templates/basic/account/withdraw.blade.php ENDPATH**/ ?>