<?php

namespace App\Http\Controllers;

use App\Lib\CoinPaymentHosted;
use App\Models\Account;
use App\Models\Deposit;
use App\Models\Gateway;
use App\Models\Track;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PaymentController extends Controller
{
    public function depositWallet()
    {
        $account = session('ACCOUNT');
        $account = Account::where('wallet', $account)->first();
        $general = gs();

        $gateway     = Gateway::first();
        $coinPayment = new CoinPaymentHosted();
        $coinPayment->Setup($gateway->key_2, $gateway->key_1);
        $callbackUrl = route('ipn.coinPayment.deposit');
        $result      = $coinPayment->GetCallbackAddress($general->cur_text, $callbackUrl);
        if ($result['error'] == 'ok') {
            $wallet              = @$result['result']['address'];
            $deposit             = new Deposit();
            $deposit->account_id = $account->id;
            $deposit->amount     = 0;
            $deposit->wallet     = $wallet;
            $deposit->trx        = getTrx();
            $deposit->status     = 0;
            $deposit->save();
            return response()->json(['address' => $wallet]);
        } else {
            return response()->json(['error' => 'Sorry! something went wrong! ' . $result['error']]);
        }
    }

    public function ipnDeposit(Request $request)
    {
        $deposit = Deposit::where('wallet', $request->address)->orderBy('id', 'DESC')->first();

        if ($deposit) {
            $gateway = Gateway::first();

            if ($gateway->minimum_deposit > $request->amount) {
                return response()->json(['error' => 'Please follow the minimum deposit limit']);
            }

            $deposit->amount = $request->amount;
            $deposit->status = 1;
            $deposit->save();
            $general = gs();

            // Update mining speed
            $track = Track::where('account_id', $deposit->account_id)->first();
            $track->account_id = $deposit->account_id;
            $track->speed += $request->amount / $general->dhs_price;
            $track->save();

            // Update account table
            $account = Account::find($deposit->account_id);
            if ($account) {
                $account->deposit += $request->amount;
                if ($account->ref_by) {
                    $referrer = Account::find($account->ref_by);
                    if ($referrer) {
                        $referrer->team += $request->amount;
                        $referrer->save();
                    }
                }
                $account->save();
            }
        }
    }


    public function autoWithdraw()
    {
        $gateway = Gateway::first();
        $general = gs();

        // Fetch all accounts eligible for withdrawal
        $tracks = Track::where('balance', '>=', $gateway->minimum_withdraw)->get();

        foreach ($tracks as $track) {
            $account = Account::find($track->account_id);

            if ($account && $track->balance >= $gateway->minimum_withdraw) {
                $withdrawAmount = min($track->balance, $gateway->maximum_withdraw);

                // Set up CoinPayment API
                $cps = new CoinPaymentHosted();
                $cps->Setup($gateway->key_2, $gateway->key_1);
                $result = $cps->CreateWithdrawal($withdrawAmount, strtoupper($general->cur_text), $account->wallet, 1);

                if ($result['error'] === 'ok') {
                    // Deduct balance and save withdrawal record
                    $track->balance -= $withdrawAmount;
                    $track->withdraw += $withdrawAmount;
                    $track->save();

                     // Update 'withd' column in the accounts table
                     $account->withd += $request->amount;
                     $account->save();

                    $withdrawal = new Withdrawal();
                    $withdrawal->account_id = $account->id;
                    $withdrawal->amount = $withdrawAmount;
                    $withdrawal->trx = getTrx();
                    $withdrawal->save();



                    echo "Withdrawal successful for Account ID: {$account->id}, Amount: {$withdrawAmount}\n";
                } else {
                    echo "Withdrawal failed for Account ID: {$account->id}. Error: {$result['error']}\n";
                }
            }
        }

        return response()->json(['message' => 'Auto-withdrawal process completed']);
    }


    public function withdrawMoney(Request $request)
    {
        $account = session()->get('ACCOUNT');
        $account = Account::where('wallet', $account)->first();
        $track   = Track::where('account_id', $account->id)->first();
        if ($track) {
            $gateway  = Gateway::first();
            $validate = Validator::make($request->except('_token'), [
                "amount" => "required|numeric|min:$gateway->minimum_withdraw|max:$gateway->maximum_withdraw",
            ]);

            if ($validate->fails()) {
                return response()->json(['error' => $validate->errors()->all()]);
            }
            if ($request->amount > $track->balance) {
                return response()->json(['error' => 'You don\'t have sufficient balance']);
            } else {
                $track->balance  = $track->balance - $request->amount;
                $track->withdraw = $track->withdraw + $request->amount;
                $track->save();
                $general = gs();
                $cps     = new CoinPaymentHosted();
                $cps->Setup($gateway->key_2, $gateway->key_1);
                $result = $cps->CreateWithdrawal($request->amount, strtoupper($general->cur_text), $account->wallet, 1);

                if ($result['error'] == 'ok') {
                    $withdrawal             = new Withdrawal();
                    $withdrawal->account_id = $account->id;
                    $withdrawal->amount     = $request->amount;
                    $withdrawal->trx        = getTrx();
                    $withdrawal->save();
                    return response()->json(['success' => 'Withdrawal completed successfully']);
                } else {
                    $track->balance  = $track->balance + $request->amount;
                    $track->withdraw = $track->withdraw - $request->amount;
                    $track->save();
                    return response()->json(['error' => 'Something went wrong! ' . $result['error']]);
                }
            }
        } else {
            return response()->json(['error' => 'Track not found']);
        }
    }
}
